/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.client;

import com.google.gson.Gson;
import java.io.IOException;
import javax.websocket.DeploymentException;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.mule.modules.slack.client.JerseySlackRequestBuilder;
import org.mule.modules.slack.client.RequestBuilderFactory;
import org.mule.modules.slack.client.SlackRequester;
import org.mule.modules.slack.client.resources.Auth;
import org.mule.modules.slack.client.resources.Channels;
import org.mule.modules.slack.client.resources.Chat;
import org.mule.modules.slack.client.resources.Files;
import org.mule.modules.slack.client.resources.Groups;
import org.mule.modules.slack.client.resources.IM;
import org.mule.modules.slack.client.resources.UserGroups;
import org.mule.modules.slack.client.resources.Users;
import org.mule.modules.slack.client.rtm.EventHandler;
import org.mule.modules.slack.client.rtm.SlackMessageHandler;

public class SlackClient {
    private static final Logger logger = Logger.getLogger(SlackClient.class);
    private SlackRequester slackRequester;
    private String selfId;
    public final Chat chat;
    public final Users users;
    public final UserGroups usergroups;
    public final Channels channels;
    public final Groups groups;
    public final Files files;
    public final Auth auth;
    public final IM im;

    public SlackClient(String token) {
        this(token, JerseySlackRequestBuilder.getFactory());
    }

    public SlackClient(String token, RequestBuilderFactory requestBuilderFactory) {
        this.slackRequester = new SlackRequester(token, requestBuilderFactory);
        Gson gson = new Gson();
        this.usergroups = new UserGroups(this.slackRequester, gson);
        this.channels = new Channels(this.slackRequester, gson);
        this.users = new Users(this.slackRequester, gson);
        this.groups = new Groups(this.slackRequester, gson);
        this.chat = new Chat(this.slackRequester, gson);
        this.auth = new Auth(this.slackRequester);
        this.im = new IM(this.slackRequester, gson);
        this.files = new Files(this.slackRequester, gson);
    }

    private String getWebSockerURI() {
        String output = this.slackRequester.newRequest("rtm.start").build().execute();
        this.selfId = new JSONObject(output).getJSONObject("self").getString("id");
        return new JSONObject(output).getString("url");
    }

    public void startRealTimeCommunication(EventHandler messageHandler, int reconnectionFrequency) throws DeploymentException, InterruptedException, IOException {
        SlackMessageHandler slackMessageHandler = new SlackMessageHandler(this.getWebSockerURI(), messageHandler);
        while (true) {
            try {
                while (true) {
                    slackMessageHandler.connect();
                }
            }
            catch (InterruptedException e) {
                logger.warn((Object)"The event listener has been interrupted and stopped definitely");
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"Error Cause: ", (Throwable)e);
                logger.warn((Object)String.format("Retrying RTM Communication in %s Seconds", reconnectionFrequency / 1000));
                Thread.sleep(reconnectionFrequency);
                logger.warn((Object)"Starting RTM Communication");
                slackMessageHandler = new SlackMessageHandler(this.getWebSockerURI(), messageHandler);
                continue;
            }
            break;
        }
    }
}

