/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.client.rtm;

import java.io.IOException;
import java.net.URI;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.glassfish.tyrus.client.ClientManager;
import org.mule.modules.slack.client.exceptions.SlackException;
import org.mule.modules.slack.client.rtm.EventHandler;

public class SlackMessageHandler
implements MessageHandler.Whole<String> {
    private String webSocketUrl;
    private Session websocketSession;
    private long lastPingSent = 0L;
    private volatile long lastPingAck = 0L;
    private boolean reconnectOnDisconnection = true;
    private long messageId = 0L;
    private final EventHandler messageHandler;

    public SlackMessageHandler(String webSocketUrl, EventHandler messageHandler) {
        this.webSocketUrl = webSocketUrl;
        this.messageHandler = messageHandler;
    }

    public void connect() throws IOException, DeploymentException, InterruptedException {
        ClientManager client = ClientManager.createClient();
        client.getProperties().put("org.glassfish.tyrus.client.http.logUpgrade", true);
        SlackMessageHandler handler = this;
        this.websocketSession = client.connectToServer((Object)new Endpoint((MessageHandler)handler){
            final /* synthetic */ MessageHandler val$handler;
            {
                this.val$handler = messageHandler;
            }

            public void onOpen(Session session, EndpointConfig config) {
                session.addMessageHandler(this.val$handler);
            }
        }, URI.create(this.webSocketUrl));
        try {
            while (true) {
                if (this.lastPingSent != this.lastPingAck) {
                    this.websocketSession.close();
                    this.lastPingSent = 0L;
                    this.lastPingAck = 0L;
                    this.connect();
                    continue;
                }
                this.lastPingSent = this.getNextMessageId();
                this.websocketSession.getBasicRemote().sendText("{\"type\":\"ping\",\"id\":" + this.lastPingSent + "}");
                Thread.sleep(20000L);
            }
        }
        catch (Exception e) {
            this.websocketSession.close();
            throw new SlackException("Error in RTM Connection", e);
        }
    }

    public void onMessage(String message) {
        if (message.contains("{\"type\":\"pong\",\"reply_to\"")) {
            int rightBracketIdx = message.indexOf(125);
            String toParse = message.substring(26, rightBracketIdx);
            this.lastPingAck = Integer.parseInt(toParse);
            return;
        }
        if (!message.contains("{\"type\":\"hello\"})")) {
            this.messageHandler.onMessage(message);
        }
    }

    private synchronized long getNextMessageId() {
        return this.messageId++;
    }
}

