
package org.mule.modules.slack.generated.sources;

import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.callback.SourceCallback;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.source.MessageSource;
import org.mule.modules.slack.SlackConnector;
import org.mule.security.oauth.callback.ProcessCallback;
import org.mule.security.oauth.processor.AbstractListeningMessageProcessor;


/**
 * RetrieveEventsMessageSource wraps {@link org.mule.modules.slack.SlackConnector#retrieveEvents(org.mule.api.callback.SourceCallback, java.lang.Boolean, java.lang.Boolean, java.lang.Boolean, java.lang.Boolean, java.lang.Boolean, java.lang.Boolean, java.lang.Boolean, java.lang.Boolean, java.lang.Boolean, java.lang.Boolean, java.lang.String, java.lang.String, int)} method in {@link SlackConnector } as a message source capable of generating Mule events.  The POJO's method is invoked in its own thread.
 * 
 */
@SuppressWarnings("all")
@Generated(value = "Mule DevKit Version 3.9.1", date = "2018-04-26T11:46:40-07:00", comments = "Build UNNAMED.2797.33dc1d7")
public class RetrieveEventsMessageSource
    extends AbstractListeningMessageProcessor
    implements Runnable, FlowConstructAware, MuleContextAware, Startable, Stoppable, MessageSource
{

    protected Object messages;
    protected Boolean _messagesType;
    protected Object userTyping;
    protected Boolean _userTypingType;
    protected Object directMessages;
    protected Boolean _directMessagesType;
    protected Object onlyNewMessages;
    protected Boolean _onlyNewMessagesType;
    protected Object ignoreSelfEvents;
    protected Boolean _ignoreSelfEventsType;
    protected Object imCreated;
    protected Boolean _imCreatedType;
    protected Object fileCreated;
    protected Boolean _fileCreatedType;
    protected Object fileShared;
    protected Boolean _fileSharedType;
    protected Object filePublic;
    protected Boolean _filePublicType;
    protected Object allEvents;
    protected Boolean _allEventsType;
    protected Object filterClassName;
    protected String _filterClassNameType;
    protected Object notifierClassName;
    protected String _notifierClassNameType;
    protected Object reconnectionFrequency;
    protected int _reconnectionFrequencyType;
    /**
     * Thread under which this message source will execute
     * 
     */
    private Thread thread;

    public RetrieveEventsMessageSource(String operationName) {
        super(operationName);
    }

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    /**
     * Sets allEvents
     * 
     * @param value Value to set
     */
    public void setAllEvents(Object value) {
        this.allEvents = value;
    }

    /**
     * Sets userTyping
     * 
     * @param value Value to set
     */
    public void setUserTyping(Object value) {
        this.userTyping = value;
    }

    /**
     * Sets notifierClassName
     * 
     * @param value Value to set
     */
    public void setNotifierClassName(Object value) {
        this.notifierClassName = value;
    }

    /**
     * Sets filePublic
     * 
     * @param value Value to set
     */
    public void setFilePublic(Object value) {
        this.filePublic = value;
    }

    /**
     * Sets ignoreSelfEvents
     * 
     * @param value Value to set
     */
    public void setIgnoreSelfEvents(Object value) {
        this.ignoreSelfEvents = value;
    }

    /**
     * Sets fileShared
     * 
     * @param value Value to set
     */
    public void setFileShared(Object value) {
        this.fileShared = value;
    }

    /**
     * Sets onlyNewMessages
     * 
     * @param value Value to set
     */
    public void setOnlyNewMessages(Object value) {
        this.onlyNewMessages = value;
    }

    /**
     * Sets fileCreated
     * 
     * @param value Value to set
     */
    public void setFileCreated(Object value) {
        this.fileCreated = value;
    }

    /**
     * Sets filterClassName
     * 
     * @param value Value to set
     */
    public void setFilterClassName(Object value) {
        this.filterClassName = value;
    }

    /**
     * Sets messages
     * 
     * @param value Value to set
     */
    public void setMessages(Object value) {
        this.messages = value;
    }

    /**
     * Sets directMessages
     * 
     * @param value Value to set
     */
    public void setDirectMessages(Object value) {
        this.directMessages = value;
    }

    /**
     * Sets imCreated
     * 
     * @param value Value to set
     */
    public void setImCreated(Object value) {
        this.imCreated = value;
    }

    /**
     * Sets reconnectionFrequency
     * 
     * @param value Value to set
     */
    public void setReconnectionFrequency(Object value) {
        this.reconnectionFrequency = value;
    }

    /**
     * Method to be called when Mule instance gets started.
     * 
     */
    public void start()
        throws MuleException
    {
        if (thread == null) {
            thread = new Thread(this, "Receiving Thread");
        }
        thread.start();
    }

    /**
     * Method to be called when Mule instance gets stopped.
     * 
     */
    public void stop()
        throws MuleException
    {
        thread.interrupt();
    }

    /**
     * Implementation {@link Runnable#run()} that will invoke the method on the pojo that this message source wraps.
     * 
     */
    public void run() {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(null, false, null);
            final ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            final SourceCallback sourceCallback = this;
            final Boolean transformedMessages = ((Boolean) transform(getMuleContext(), ((MuleEvent) null), getClass().getDeclaredField("_messagesType").getGenericType(), null, messages));
            final Boolean transformedUserTyping = ((Boolean) transform(getMuleContext(), ((MuleEvent) null), getClass().getDeclaredField("_userTypingType").getGenericType(), null, userTyping));
            final Boolean transformedDirectMessages = ((Boolean) transform(getMuleContext(), ((MuleEvent) null), getClass().getDeclaredField("_directMessagesType").getGenericType(), null, directMessages));
            final Boolean transformedOnlyNewMessages = ((Boolean) transform(getMuleContext(), ((MuleEvent) null), getClass().getDeclaredField("_onlyNewMessagesType").getGenericType(), null, onlyNewMessages));
            final Boolean transformedIgnoreSelfEvents = ((Boolean) transform(getMuleContext(), ((MuleEvent) null), getClass().getDeclaredField("_ignoreSelfEventsType").getGenericType(), null, ignoreSelfEvents));
            final Boolean transformedImCreated = ((Boolean) transform(getMuleContext(), ((MuleEvent) null), getClass().getDeclaredField("_imCreatedType").getGenericType(), null, imCreated));
            final Boolean transformedFileCreated = ((Boolean) transform(getMuleContext(), ((MuleEvent) null), getClass().getDeclaredField("_fileCreatedType").getGenericType(), null, fileCreated));
            final Boolean transformedFileShared = ((Boolean) transform(getMuleContext(), ((MuleEvent) null), getClass().getDeclaredField("_fileSharedType").getGenericType(), null, fileShared));
            final Boolean transformedFilePublic = ((Boolean) transform(getMuleContext(), ((MuleEvent) null), getClass().getDeclaredField("_filePublicType").getGenericType(), null, filePublic));
            final Boolean transformedAllEvents = ((Boolean) transform(getMuleContext(), ((MuleEvent) null), getClass().getDeclaredField("_allEventsType").getGenericType(), null, allEvents));
            final String transformedFilterClassName = ((String) transform(getMuleContext(), ((MuleEvent) null), getClass().getDeclaredField("_filterClassNameType").getGenericType(), null, filterClassName));
            final String transformedNotifierClassName = ((String) transform(getMuleContext(), ((MuleEvent) null), getClass().getDeclaredField("_notifierClassNameType").getGenericType(), null, notifierClassName));
            final Integer transformedReconnectionFrequency = ((Integer) transform(getMuleContext(), ((MuleEvent) null), getClass().getDeclaredField("_reconnectionFrequencyType").getGenericType(), null, reconnectionFrequency));
            processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class<? extends Exception>> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    ((SlackConnector) object).retrieveEvents(sourceCallback, transformedMessages, transformedUserTyping, transformedDirectMessages, transformedOnlyNewMessages, transformedIgnoreSelfEvents, transformedImCreated, transformedFileCreated, transformedFileShared, transformedFilePublic, transformedAllEvents, transformedFilterClassName, transformedNotifierClassName, transformedReconnectionFrequency);
                    return null;
                }

            }
            , null, ((MuleEvent) null));
        } catch (MessagingException e) {
            getFlowConstruct().getExceptionListener().handleException(e, e.getEvent());
        } catch (Exception e) {
            getMuleContext().getExceptionListener().handleException(e);
        }
    }

}
