/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.client;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.shaded.client.Client;
import javax.ws.rs.shaded.client.ClientBuilder;
import javax.ws.rs.shaded.client.Entity;
import javax.ws.rs.shaded.client.Invocation;
import javax.ws.rs.shaded.client.WebTarget;
import javax.ws.rs.shaded.core.Configurable;
import javax.ws.rs.shaded.core.Configuration;
import javax.ws.rs.shaded.core.MediaType;
import javax.ws.rs.shaded.core.Response;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.glassfish.jersey.shaded.client.ClientConfig;
import org.glassfish.jersey.shaded.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.shaded.media.multipart.MultiPartFeature;
import org.glassfish.jersey.shaded.media.multipart.file.StreamDataBodyPart;
import org.mule.modules.slack.client.ErrorHandler;
import org.mule.modules.slack.client.SlackRequest;

public class JerseySlackRequest
extends SlackRequest {
    private static final String PLUS = "+";
    private static final String SPACE = " ";
    private static final URLCodec codec = new URLCodec("UTF-8");
    private final HashMap<String, InputStream> parts;

    JerseySlackRequest(String token, String apiMethod, Map<String, String> queryParams, HashMap<String, InputStream> parts) {
        super(token, apiMethod, queryParams);
        this.parts = parts;
    }

    @Override
    public String execute() {
        WebTarget webTarget = this.getWebTarget().path(this.apiMethod);
        for (Map.Entry entry : this.queryParams.entrySet()) {
            try {
                String encode = codec.encode((String)entry.getValue());
                encode = encode.replace(PLUS, SPACE);
                webTarget = webTarget.queryParam((String)entry.getKey(), encode);
            }
            catch (EncoderException e) {
                throw new RuntimeException(e);
            }
        }
        if (!this.parts.isEmpty()) {
            return JerseySlackRequest.sendRequestWithFile(webTarget, this.parts.get("file"));
        }
        return JerseySlackRequest.sendRequest(webTarget);
    }

    private WebTarget getWebTarget() {
        Configurable clientConfig = new ClientConfig().register((Class)MultiPartFeature.class);
        Client client = ClientBuilder.newClient((Configuration)((Object)clientConfig));
        return client.target(this.SLACK_API_BASE_URI).queryParam("token", this.token);
    }

    private static String sendRequest(WebTarget webTarget) {
        Invocation.Builder invocationBuilder = webTarget.request("application/json");
        Response response = invocationBuilder.get();
        if (response.getStatus() != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + response.getStatus());
        }
        String output = response.readEntity(String.class);
        ErrorHandler.verifyResponse(output);
        return output;
    }

    public static String sendRequestWithFile(WebTarget webTarget, InputStream file) {
        FormDataMultiPart multiPart = new FormDataMultiPart();
        multiPart.bodyPart(new StreamDataBodyPart("file", file, "file", MediaType.APPLICATION_OCTET_STREAM_TYPE));
        Response response = webTarget.request("multipart/form-data").post(Entity.entity(multiPart, multiPart.getMediaType()));
        if (response.getStatus() != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + response.getStatus());
        }
        String output = response.readEntity(String.class);
        ErrorHandler.verifyResponse(output);
        return output;
    }
}

