/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.client.resources;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.modules.slack.client.SlackRequester;
import org.mule.modules.slack.client.exceptions.SlackException;
import org.mule.modules.slack.client.model.channel.Channel;
import org.mule.modules.slack.client.model.chat.Message;

public class Channels {
    protected static final String CHANNEL = "channel";
    private final SlackRequester slackRequester;
    private final Gson gson;

    public Channels(SlackRequester slackRequester, Gson gson) {
        this.slackRequester = slackRequester;
        this.gson = gson;
    }

    public List<Channel> getChannelList(Boolean excludeArchived, Boolean excludeMembers, int limit, String cursor) {
        ArrayList<Channel> list = new ArrayList<Channel>();
        String output = this.slackRequester.newRequest("channels.list").withParam("exclude_archived", excludeArchived).withParam("exclude_members", excludeMembers).withParam("limit", limit).withParam("cursor", cursor).build().execute();
        JSONArray channels = (JSONArray)new JSONObject(output).get("channels");
        for (int i = 0; i < channels.length(); ++i) {
            JSONObject channel = (JSONObject)channels.get(i);
            Channel newChannel = (Channel)this.gson.fromJson(channel.toString(), Channel.class);
            list.add(newChannel);
        }
        return list;
    }

    public Boolean leaveChannel(String channelId) {
        String output = this.slackRequester.newRequest("channels.leave").withParam(CHANNEL, channelId).build().execute();
        return new JSONObject(output).getBoolean("ok");
    }

    public Channel getChannelById(String id) {
        String output = this.slackRequester.newRequest("channels.info").withParam(CHANNEL, id).build().execute();
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get(CHANNEL);
        return (Channel)this.gson.fromJson(slackResponse.toString(), Channel.class);
    }

    public List<Message> getChannelHistory(String channelId, String latest, String oldest, String count) {
        return this.getMessages(channelId, latest, oldest, count, "channels.history");
    }

    public Channel createChannel(String channelName) {
        String output = this.slackRequester.newRequest("channels.create").withParam("name", channelName).build().execute();
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get(CHANNEL);
        return (Channel)this.gson.fromJson(slackResponse.toString(), Channel.class);
    }

    public Channel renameChannel(String channelId, String newName) {
        String output = this.slackRequester.newRequest("channels.rename").withParam("name", newName).withParam(CHANNEL, channelId).build().execute();
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get(CHANNEL);
        return (Channel)this.gson.fromJson(slackResponse.toString(), Channel.class);
    }

    public Channel joinChannel(String channelName) {
        String output = this.slackRequester.newRequest("channels.join").withParam("name", channelName).build().execute();
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get(CHANNEL);
        return (Channel)this.gson.fromJson(slackResponse.toString(), Channel.class);
    }

    public Channel getChannelByName(String name) {
        List<Channel> list = this.getChannelList(false, true, 0, null);
        for (Channel channel : list) {
            if (!channel.getName().equals(name)) continue;
            return channel;
        }
        throw new SlackException("Channel: " + name + " does not exist.");
    }

    public Boolean setChannelPurpose(String channelID, String purpose) {
        String output = this.slackRequester.newRequest("channels.setPurpose").withParam(CHANNEL, channelID).withParam("purpose", purpose).build().execute();
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean setChannelTopic(String channelID, String topic) {
        String output = this.slackRequester.newRequest("channels.setTopic").withParam(CHANNEL, channelID).withParam("topic", topic).build().execute();
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean markViewChannel(String channelID, String timeStamp) {
        String output = this.slackRequester.newRequest("channels.mark").withParam(CHANNEL, channelID).withParam("ts", timeStamp).build().execute();
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean kickUserFromChannel(String channelID, String user) {
        String output = this.slackRequester.newRequest("channels.kick").withParam(CHANNEL, channelID).withParam("user", user).build().execute();
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean inviteUserToChannel(String channelID, String user) {
        String output = this.slackRequester.newRequest("channels.invite").withParam(CHANNEL, channelID).withParam("user", user).build().execute();
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean unarchiveChannel(String channelID) {
        String output = this.slackRequester.newRequest("channels.unarchive").withParam(CHANNEL, channelID).build().execute();
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean archiveChannel(String channelID) {
        String output = this.slackRequester.newRequest("channels.archive").withParam(CHANNEL, channelID).build().execute();
        return new JSONObject(output).getBoolean("ok");
    }

    public List<Message> getMessages(String channelId, String latest, String oldest, String count, String operation) {
        String output = this.slackRequester.newRequest(operation).withParam(CHANNEL, channelId).withParam("latest", latest).withParam("oldest", oldest).withParam("count", count).build().execute();
        JSONArray slackResponse = (JSONArray)new JSONObject(output).get("messages");
        Type listType = new TypeToken<ArrayList<Message>>(){}.getType();
        return (List)this.gson.fromJson(slackResponse.toString(), listType);
    }
}

