/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.client.resources;

import com.google.gson.Gson;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.mule.modules.slack.client.SlackRequester;
import org.mule.modules.slack.client.model.chat.MessageResponse;

public class Chat {
    private final SlackRequester slackRequester;
    private final Gson gson;

    public Chat(SlackRequester slackRequester, Gson gson) {
        this.slackRequester = slackRequester;
        this.gson = gson;
    }

    public MessageResponse sendMessage(String message, String channelId, String username, String iconUrl, Boolean asUser) {
        String output = this.slackRequester.newRequest("chat.postMessage").withParam("channel", channelId).withParam("text", message).withParam("username", username).withParam("icon_url", iconUrl).withParam("as_user", asUser).build().execute();
        return (MessageResponse)this.gson.fromJson(output, MessageResponse.class);
    }

    public String sendMessageWithAttachments(String message, String channelId, String username, String iconUrl, String attachments, Boolean asUser) {
        return this.slackRequester.newRequest("chat.postMessage").withParam("channel", channelId).withParam("text", message).withParam("username", username).withParam("icon_url", iconUrl).withParam("as_user", asUser).withParam("attachments", attachments).build().execute();
    }

    public Boolean deleteMessage(String timeStamp, String channelId) {
        String output = this.slackRequester.newRequest("chat.delete").withParam("channel", channelId).withParam("ts", timeStamp).build().execute();
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean updateMessage(String timeStamp, String channelId, String message) {
        String output = this.slackRequester.newRequest("chat.update").withParam("channel", channelId).withParam("text", message).withParam("ts", timeStamp).build().execute();
        return new JSONObject(output).getBoolean("ok");
    }

    private String encode(String text) {
        try {
            if (!StringUtils.isBlank((String)text)) {
                text = text.replace("\\\\n", "\n");
                return URIUtil.encodeAll((String)text, (String)"UTF-8");
            }
            return text;
        }
        catch (URIException e) {
            throw new RuntimeException(e);
        }
    }
}

