/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.client.resources;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.modules.slack.client.SlackRequester;
import org.mule.modules.slack.client.model.chat.Message;
import org.mule.modules.slack.client.model.group.Group;

public class Groups {
    private final Type groupsListType = new TypeToken<List<Group>>(){}.getType();
    private final SlackRequester slackRequester;
    private final Gson gson;

    public Groups(SlackRequester slackRequester, Gson gson) {
        this.slackRequester = slackRequester;
        this.gson = gson;
    }

    public List<Message> getGroupHistory(String channelId, String latest, String oldest, String count) {
        return this.getMessages(channelId, latest, oldest, count, "groups.history");
    }

    public List<Group> getGroupList(Boolean excludeMembers, Boolean excludeArchived) {
        String output = this.slackRequester.newRequest("groups.list").withParam("exclude_members", excludeMembers).withParam("exclude_archived", excludeArchived).build().execute();
        JSONArray slackResponse = (JSONArray)new JSONObject(output).get("groups");
        return (List)this.gson.fromJson(slackResponse.toString(), this.groupsListType);
    }

    public Group createGroup(String name) {
        String output = this.slackRequester.newRequest("groups.create").withParam("name", name).build().execute();
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get("group");
        return (Group)this.gson.fromJson(slackResponse.toString(), Group.class);
    }

    public Boolean openGroup(String channelID) {
        String output = this.slackRequester.newRequest("groups.open").withParam("channel", channelID).build().execute();
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean leaveGroup(String channelID) {
        String output = this.slackRequester.newRequest("groups.leave").withParam("channel", channelID).build().execute();
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean archiveGroup(String channelID) {
        String output = this.slackRequester.newRequest("groups.archive").withParam("channel", channelID).build().execute();
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean setGroupPurpose(String channelID, String purpose) {
        String output = this.slackRequester.newRequest("groups.setPurpose").withParam("channel", channelID).withParam("purpose", purpose).build().execute();
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean setGroupTopic(String channelID, String topic) {
        String output = this.slackRequester.newRequest("groups.setTopic").withParam("channel", channelID).withParam("topic", topic).build().execute();
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean closeGroup(String channelID) {
        String output = this.slackRequester.newRequest("groups.close").withParam("channel", channelID).build().execute();
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean markViewGroup(String channelID, String timeStamp) {
        String output = this.slackRequester.newRequest("groups.mark").withParam("channel", channelID).withParam("ts", timeStamp).build().execute();
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean kickUserFromGroup(String channelID, String user) {
        String output = this.slackRequester.newRequest("groups.kick").withParam("channel", channelID).withParam("user", user).build().execute();
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean inviteUserToGroup(String channelID, String user) {
        String output = this.slackRequester.newRequest("groups.invite").withParam("channel", channelID).withParam("user", user).build().execute();
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean unarchiveGroup(String groupID) {
        String output = this.slackRequester.newRequest("groups.unarchive").withParam("channel", groupID).build().execute();
        return new JSONObject(output).getBoolean("ok");
    }

    public Group renameGroup(String channelId, String newName) {
        String output = this.slackRequester.newRequest("groups.rename").withParam("channel", channelId).withParam("name", newName).build().execute();
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get("channel");
        return (Group)this.gson.fromJson(slackResponse.toString(), Group.class);
    }

    public Group getGroupInfo(String groupId) {
        String output = this.slackRequester.newRequest("groups.info").withParam("channel", groupId).build().execute();
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get("group");
        return (Group)this.gson.fromJson(slackResponse.toString(), Group.class);
    }

    public List<Message> getMessages(String channelId, String latest, String oldest, String count, String operation) {
        String output = this.slackRequester.newRequest(operation).withParam("channel", channelId).withParam("latest", latest).withParam("oldest", oldest).withParam("count", count).build().execute();
        JSONArray slackResponse = (JSONArray)new JSONObject(output).get("messages");
        Type listType = new TypeToken<ArrayList<Message>>(){}.getType();
        return (List)this.gson.fromJson(slackResponse.toString(), listType);
    }
}

