/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.client.resources;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.modules.slack.client.SlackRequester;
import org.mule.modules.slack.client.exceptions.SlackException;
import org.mule.modules.slack.client.model.User;

public class Users {
    private final Type usersListType = new TypeToken<List<User>>(){}.getType();
    private final SlackRequester slackRequester;
    private final Gson gson;

    public Users(SlackRequester slackRequester, Gson gson) {
        this.slackRequester = slackRequester;
        this.gson = gson;
    }

    public User getUserInfo(String id) {
        String output = this.slackRequester.newRequest("users.info").withParam("user", id).build().execute();
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get("user");
        return (User)this.gson.fromJson(slackResponse.toString(), User.class);
    }

    public List<User> getUserList() {
        String output = this.slackRequester.newRequest("users.list").build().execute();
        JSONArray slackResponse = (JSONArray)new JSONObject(output).get("members");
        return (List)this.gson.fromJson(slackResponse.toString(), this.usersListType);
    }

    public User getUserInfoByName(String username) {
        List<User> list = this.getUserList();
        for (User user : list) {
            if (!user.getName().equals(username)) continue;
            return user;
        }
        throw new SlackException("The user: " + username + " does not exist, please check the name!");
    }
}

