/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.config;

import com.github.estebanwasinger.http.bridge.api.DefaultHttpClientBridgeFactory;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.module.http.internal.request.HttpClient;
import org.mule.modules.slack.client.JerseySlackRequestBuilder;
import org.mule.modules.slack.client.MuleHttpClientSlackRequestBuilder;
import org.mule.modules.slack.client.SlackClient;
import org.mule.modules.slack.config.HttpClientType;

public abstract class SlackConfig {
    HttpClient httpClient;
    private HttpClientType httpClientType;

    public abstract SlackClient getSlackClient();

    abstract String getToken();

    abstract Boolean isAuthorized();

    SlackClient createSlackClient(String accessToken, MuleContext muleContext) throws ConnectionException {
        switch (this.httpClientType) {
            case MULE: {
                this.createMuleHttpClient(muleContext);
                return new SlackClient(accessToken, MuleHttpClientSlackRequestBuilder.getFactory(this.httpClient));
            }
            case JERSEY: {
                return new SlackClient(accessToken, JerseySlackRequestBuilder.getFactory());
            }
        }
        throw new RuntimeException();
    }

    private void createMuleHttpClient(MuleContext muleContext) throws ConnectionException {
        this.httpClient = new DefaultHttpClientBridgeFactory(muleContext).createClient(100, true, 10000, "slack-connector", "slack");
        try {
            this.startHttpClient();
        }
        catch (MuleException e) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, "", "", (Throwable)e);
        }
    }

    private void startHttpClient() throws MuleException {
        if (this.httpClient instanceof Startable) {
            ((Startable)this.httpClient).start();
        } else if (this.httpClient instanceof Initialisable) {
            this.httpClient.initialise();
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public HttpClientType getHttpClientType() {
        return this.httpClientType;
    }

    public void setHttpClientType(HttpClientType httpClientType) {
        this.httpClientType = httpClientType;
    }
}

