/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.config;

import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.MuleContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.MuleContextAware;
import org.mule.modules.slack.client.SlackClient;
import org.mule.modules.slack.config.SlackConfig;

public class SlackTokenConfig
extends SlackConfig
implements MuleContextAware {
    private SlackClient slackClient;
    private String accessToken;
    private MuleContext muleContext;

    public void connect(String accessToken) throws ConnectionException {
        this.slackClient = this.createSlackClient(accessToken, this.muleContext);
        if (!this.slackClient.auth.isConnected().booleanValue()) {
            throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, "Invalid Token", "Invalid Token");
        }
    }

    public void disconnect() {
        this.slackClient = null;
        try {
            if (this.httpClient != null) {
                this.httpClient.stop();
            }
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public boolean isValid() {
        return this.slackClient != null && this.slackClient.auth.isConnected() != false;
    }

    public String getConnectionIdentifier() {
        return this.accessToken;
    }

    @Override
    public SlackClient getSlackClient() {
        return this.slackClient;
    }

    @Override
    public String getToken() {
        return this.accessToken;
    }

    public void setToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.slackClient = new SlackClient(accessToken);
        this.accessToken = accessToken;
    }

    @Override
    public Boolean isAuthorized() {
        return this.accessToken != null;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

