/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.metadata;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.modules.slack.SlackConnector;
import org.mule.modules.slack.client.model.User;
import org.mule.modules.slack.client.model.channel.Channel;
import org.mule.modules.slack.client.model.group.Group;
import org.mule.modules.slack.client.model.im.DirectMessageChannel;

public class AllChannelCategory {
    @Inject
    private SlackConnector connector;

    public List<MetaDataKey> getEntities() throws Exception {
        ArrayList<MetaDataKey> entities = new ArrayList<MetaDataKey>();
        List<Channel> channelList = this.connector.slack().channels.getChannelList(true, true, 0, null);
        for (Channel channel : channelList) {
            entities.add((MetaDataKey)new DefaultMetaDataKey(channel.getId(), channel.getName() + " - " + channel.getId()));
        }
        List<DirectMessageChannel> dmList = this.connector.slack().im.getDirectMessageChannelsList();
        List<User> userList = this.connector.slack().users.getUserList();
        for (DirectMessageChannel group : dmList) {
            entities.add((MetaDataKey)new DefaultMetaDataKey(group.getId(), this.userName(userList, group.getUser()) + " - " + group.getId()));
        }
        List<Group> groupList = this.connector.slack().groups.getGroupList(true, true);
        for (Group group : groupList) {
            entities.add((MetaDataKey)new DefaultMetaDataKey(group.getId(), group.getName() + " - " + group.getId()));
        }
        return entities;
    }

    private String userName(List<User> userList, String userId) {
        for (User user : userList) {
            if (!user.getId().equals(userId)) continue;
            return user.getName();
        }
        return null;
    }

    public MetaData describeEntity(MetaDataKey entityKey) throws Exception {
        return null;
    }

    public SlackConnector getConnector() {
        return this.connector;
    }

    public void setConnector(SlackConnector connector) {
        this.connector = connector;
    }
}

