/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.stripe.internal.operation;

import com.mulesoft.connectivity.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.error.RequestErrorTypeProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectivity.rest.commons.api.operation.ConfigurationOverrides;
import com.mulesoft.connectivity.rest.commons.api.operation.EntityRequestParameters;
import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.rest.commons.api.operation.RequestParameters;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectors.stripe.internal.metadata.CreateV1CustomersByCustomerInputMetadataResolver;
import com.mulesoft.connectors.stripe.internal.metadata.CreateV1CustomersByCustomerOutputMetadataResolver;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;

public class CreateV1CustomersByCustomerOperation
extends BaseRestOperation {
    private static final Pattern CUSTOMER_PATTERN = Pattern.compile("\\{customer}");
    private static final RestRequestBuilder.QueryParamFormat QUERY_PARAM_FORMAT = RestRequestBuilder.QueryParamFormat.MULTIMAP;

    @Throws(value={RequestErrorTypeProvider.class})
    @DisplayName(value="Update Customer")
    @Summary(value="<p>Updates the specified customer by setting the values of the parameters passed.")
    @MediaType(value="application/json")
    @OutputResolver(output=CreateV1CustomersByCustomerOutputMetadataResolver.class)
    public void createV1CustomersByCustomer(@Config RestConfiguration config, @Connection RestConnection connection, @DisplayName(value="customer") String customer, @Content(primary=true) @TypeResolver(value=CreateV1CustomersByCustomerInputMetadataResolver.class) TypedValue<InputStream> content, @ParameterGroup(name="Request Parameters") EntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        String requestPath = "/v1/customers/{customer}";
        requestPath = CUSTOMER_PATTERN.matcher(requestPath).replaceAll(customer);
        RestRequestBuilder builder = new RestRequestBuilder(connection.getBaseUri(), requestPath, HttpConstants.Method.POST, (RequestParameters)parameters).setQueryParamFormat(QUERY_PARAM_FORMAT).addHeader("content-type", "application/x-www-form-urlencoded").addHeader("accept", "application/json").setBody(content, overrides.getStreamingType());
        this.doRequest(config, connection, builder, overrides.getResponseTimeoutAsMillis(), streamingHelper, callback);
    }
}

