/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.stripe.internal.operation;

import com.mulesoft.connectivity.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.error.RequestErrorTypeProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectivity.rest.commons.api.operation.ConfigurationOverrides;
import com.mulesoft.connectivity.rest.commons.api.operation.EntityRequestParameters;
import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.rest.commons.api.operation.RequestParameters;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectors.stripe.internal.metadata.DeleteV1SubscriptionsBySubscriptionExposedIdInputMetadataResolver;
import com.mulesoft.connectors.stripe.internal.metadata.DeleteV1SubscriptionsBySubscriptionExposedIdOutputMetadataResolver;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;

public class DeleteV1SubscriptionsBySubscriptionExposedIdOperation
extends BaseRestOperation {
    private static final Pattern SUBSCRIPTION_EXPOSED_ID_PATTERN = Pattern.compile("\\{subscription_exposed_id}");
    private static final RestRequestBuilder.QueryParamFormat QUERY_PARAM_FORMAT = RestRequestBuilder.QueryParamFormat.MULTIMAP;

    @Throws(value={RequestErrorTypeProvider.class})
    @DisplayName(value="Cancel Subscription")
    @Summary(value="<p>Cancels a customer\u00c3\u0083\u00c2\u00a2\u00c3\u00a2\u00e2\u0080\u009a\u00c2\u00ac\u00c3\u00a2\u00e2\u0080\u009e\u00c2\u00a2s subscription immediately. The customer will not be charged again for the subscription.")
    @MediaType(value="application/json")
    @OutputResolver(output=DeleteV1SubscriptionsBySubscriptionExposedIdOutputMetadataResolver.class)
    public void deleteV1SubscriptionsBySubscriptionExposedId(@Config RestConfiguration config, @Connection RestConnection connection, @DisplayName(value="Subscription exposed id") String subscriptionExposedId, @Content(primary=true) @TypeResolver(value=DeleteV1SubscriptionsBySubscriptionExposedIdInputMetadataResolver.class) TypedValue<InputStream> content, @ParameterGroup(name="Request Parameters") EntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        String requestPath = "/v1/subscriptions/{subscription_exposed_id}";
        requestPath = SUBSCRIPTION_EXPOSED_ID_PATTERN.matcher(requestPath).replaceAll(subscriptionExposedId);
        RestRequestBuilder builder = new RestRequestBuilder(connection.getBaseUri(), requestPath, HttpConstants.Method.DELETE, (RequestParameters)parameters).setQueryParamFormat(QUERY_PARAM_FORMAT).addHeader("content-type", "application/x-www-form-urlencoded").addHeader("accept", "application/json").setBody(content, overrides.getStreamingType());
        this.doRequest(config, connection, builder, overrides.getResponseTimeoutAsMillis(), streamingHelper, callback);
    }
}

