/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.stripe.internal.operation;

import com.mulesoft.connectivity.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.error.RequestErrorTypeProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectivity.rest.commons.api.operation.ConfigurationOverrides;
import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.rest.commons.api.operation.NonEntityRequestParameters;
import com.mulesoft.connectivity.rest.commons.api.operation.RequestParameters;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectors.stripe.internal.metadata.GetV1ChargesByChargeOutputMetadataResolver;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;

public class GetV1ChargesByChargeOperation
extends BaseRestOperation {
    private static final Pattern CHARGE_PATTERN = Pattern.compile("\\{charge}");
    private static final RestRequestBuilder.QueryParamFormat QUERY_PARAM_FORMAT = RestRequestBuilder.QueryParamFormat.MULTIMAP;

    @Throws(value={RequestErrorTypeProvider.class})
    @DisplayName(value="Find Charge")
    @Summary(value="<p>Retrieves the details of a charge that has previously been created.")
    @MediaType(value="application/json")
    @OutputResolver(output=GetV1ChargesByChargeOutputMetadataResolver.class)
    public void getV1ChargesByCharge(@Config RestConfiguration config, @Connection RestConnection connection, @DisplayName(value="charge") String charge, @Optional @NullSafe @DisplayName(value="expand") @Summary(value="Specifies which fields in the response should be expanded.") List<String> expands, @ParameterGroup(name="Request Parameters") NonEntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        String requestPath = "/v1/charges/{charge}";
        requestPath = CHARGE_PATTERN.matcher(requestPath).replaceAll(charge);
        RestRequestBuilder builder = new RestRequestBuilder(connection.getBaseUri(), requestPath, HttpConstants.Method.GET, (RequestParameters)parameters).setQueryParamFormat(QUERY_PARAM_FORMAT).addHeader("accept", "application/json").addQueryParams("expand", expands.stream().filter(Objects::nonNull).map(v -> String.valueOf(v)).collect(Collectors.toList()));
        this.doRequest(config, connection, builder, overrides.getResponseTimeoutAsMillis(), streamingHelper, callback);
    }
}

