/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.stripe.internal.operation;

import com.mulesoft.connectivity.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.error.RequestErrorTypeProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectivity.rest.commons.api.operation.ConfigurationOverrides;
import com.mulesoft.connectivity.rest.commons.api.operation.NonEntityRequestParameters;
import com.mulesoft.connectivity.rest.commons.api.operation.RequestParameters;
import com.mulesoft.connectivity.rest.commons.api.operation.paging.MarkerPagingProvider;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectors.stripe.internal.metadata.GetV1CustomersPagingMetadataResolver;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;

public class GetV1CustomersOperation
extends BaseRestOperation {
    private static final RestRequestBuilder.QueryParamFormat QUERY_PARAM_FORMAT = RestRequestBuilder.QueryParamFormat.MULTIMAP;
    @Inject
    private ExpressionLanguage expressionLanguage;

    @Throws(value={RequestErrorTypeProvider.class})
    @DisplayName(value="List All Customers")
    @Summary(value="<p>Returns a list of your customers.")
    @OutputResolver(output=GetV1CustomersPagingMetadataResolver.class)
    public PagingProvider<RestConnection, TypedValue<String>> getV1Customers(@Config RestConfiguration config, @Optional @DisplayName(value="Ending before") @Summary(value="A cursor for use in pagination. `ending_before` is an object ID that defines your place in the list.") String endingBefore, @Optional @DisplayName(value="email") @Summary(value="A filter on the list based on the customer''s `email` field. The value must be a string.") String email, @Optional @NullSafe @DisplayName(value="expand") @Summary(value="Specifies which fields in the response should be expanded.") List<String> expands, @Optional @DisplayName(value="created[gt]") Integer createdgt, @Optional @DisplayName(value="limit") @Summary(value="A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 10.") Integer limit, @Optional @DisplayName(value="created") Integer created, @ParameterGroup(name="Request Parameters") NonEntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, StreamingHelper streamingHelper) {
        Function<RestConnection, RestRequestBuilder> requestFactory = connection -> {
            String requestPath = "/v1/customers";
            RestRequestBuilder builder = new RestRequestBuilder(connection.getBaseUri(), requestPath, HttpConstants.Method.GET, (RequestParameters)parameters).setQueryParamFormat(QUERY_PARAM_FORMAT).addHeader("accept", "application/json").addQueryParam("ending_before", endingBefore).addQueryParam("email", email).addQueryParams("expand", expands.stream().filter(Objects::nonNull).map(v -> String.valueOf(v)).collect(Collectors.toList())).addQueryParam("created[gt]", createdgt != null ? String.valueOf(createdgt) : null).addQueryParam("limit", limit != null ? String.valueOf(limit) : null).addQueryParam("created", created != null ? String.valueOf(created) : null);
            return builder;
        };
        return new MarkerPagingProvider("starting_after", "#[payload.data[-1].id]", requestFactory, this.expressionLanguage, streamingHelper, "#[payload.data]", this.resolveDefaultResponseMediaType(config), overrides.getResponseTimeoutAsMillis());
    }
}

