/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.stripe.internal.operation;

import com.mulesoft.connectivity.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.error.RequestErrorTypeProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectivity.rest.commons.api.operation.ConfigurationOverrides;
import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.rest.commons.api.operation.NonEntityRequestParameters;
import com.mulesoft.connectivity.rest.commons.api.operation.RequestParameters;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectors.stripe.internal.metadata.GetV1EventsOutputMetadataResolver;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;

public class GetV1EventsOperation
extends BaseRestOperation {
    private static final RestRequestBuilder.QueryParamFormat QUERY_PARAM_FORMAT = RestRequestBuilder.QueryParamFormat.MULTIMAP;

    @Throws(value={RequestErrorTypeProvider.class})
    @DisplayName(value="Get Events")
    @Summary(value="<p>List events, going back up to 30 days.")
    @MediaType(value="application/json")
    @OutputResolver(output=GetV1EventsOutputMetadataResolver.class)
    public void getV1Events(@Config RestConfiguration config, @Connection RestConnection connection, @Optional @DisplayName(value="Ending before") @Summary(value="A cursor for use in pagination. `ending_before` is an object ID that defines your place in the list.") String endingBefore, @Optional @DisplayName(value="Starting after") @Summary(value="A cursor for use in pagination. `starting_after` is an object ID that defines your place in the list.") String startingAfter, @Optional @NullSafe @DisplayName(value="expand") @Summary(value="Specifies which fields in the response should be expanded.") List<String> expands, @Optional @DisplayName(value="type") @Summary(value="A string containing a specific event name, or group of events using * as a wildcard.") String type, @Optional @DisplayName(value="created[gt]") Integer createdgt, @Optional @NullSafe @DisplayName(value="types") @Summary(value="An array of up to 20 strings containing specific event names.") List<String> types, @Optional @DisplayName(value="limit") @Summary(value="A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 10.") Integer limit, @Optional @DisplayName(value="Delivery success") @Summary(value="Filter events by whether all webhooks were successfully delivered.") boolean deliverySuccess, @Optional @DisplayName(value="created") Integer created, @ParameterGroup(name="Request Parameters") NonEntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        String requestPath = "/v1/events";
        RestRequestBuilder builder = new RestRequestBuilder(connection.getBaseUri(), requestPath, HttpConstants.Method.GET, (RequestParameters)parameters).setQueryParamFormat(QUERY_PARAM_FORMAT).addHeader("accept", "application/json").addQueryParam("ending_before", endingBefore).addQueryParam("starting_after", startingAfter).addQueryParams("expand", expands.stream().filter(Objects::nonNull).map(v -> String.valueOf(v)).collect(Collectors.toList())).addQueryParam("type", type).addQueryParam("created[gt]", createdgt != null ? String.valueOf(createdgt) : null).addQueryParams("types", types.stream().filter(Objects::nonNull).map(v -> String.valueOf(v)).collect(Collectors.toList())).addQueryParam("limit", limit != null ? String.valueOf(limit) : null).addQueryParam("delivery_success", String.valueOf(deliverySuccess)).addQueryParam("created", created != null ? String.valueOf(created) : null);
        this.doRequest(config, connection, builder, overrides.getResponseTimeoutAsMillis(), streamingHelper, callback);
    }
}

