/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.stripe.internal.operation;

import com.mulesoft.connectivity.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.error.RequestErrorTypeProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectivity.rest.commons.api.operation.ConfigurationOverrides;
import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.rest.commons.api.operation.NonEntityRequestParameters;
import com.mulesoft.connectivity.rest.commons.api.operation.RequestParameters;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectors.stripe.internal.metadata.GetV1SubscriptionsOutputMetadataResolver;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;

public class GetV1SubscriptionsOperation
extends BaseRestOperation {
    private static final RestRequestBuilder.QueryParamFormat QUERY_PARAM_FORMAT = RestRequestBuilder.QueryParamFormat.MULTIMAP;

    @Throws(value={RequestErrorTypeProvider.class})
    @DisplayName(value="Get Subscriptions")
    @Summary(value="<p>By default, returns a list of subscriptions that have not been canceled.")
    @MediaType(value="application/json")
    @OutputResolver(output=GetV1SubscriptionsOutputMetadataResolver.class)
    public void getV1Subscriptions(@Config RestConfiguration config, @Connection RestConnection connection, @Optional @DisplayName(value="Ending before") @Summary(value="A cursor for use in pagination. `ending_before` is an object ID that defines your place in the list.") String endingBefore, @Optional @DisplayName(value="Collection method") @Summary(value="The collection method of the subscriptions to retrieve. Either `charge_automatically` or `send_invoice`.") String collectionMethod, @Optional @DisplayName(value="Starting after") @Summary(value="A cursor for use in pagination. `starting_after` is an object ID that defines your place in the list.") String startingAfter, @Optional @DisplayName(value="Current period start") Integer currentPeriodStart, @Optional @NullSafe @DisplayName(value="expand") @Summary(value="Specifies which fields in the response should be expanded.") List<String> expands, @Optional @DisplayName(value="status") @Summary(value="The status of the subscriptions to retrieve.") String status, @Optional @DisplayName(value="customer") @Summary(value="The ID of the customer whose subscriptions will be retrieved.") String customer, @Optional @DisplayName(value="Current period end") Integer currentPeriodEnd, @Optional @DisplayName(value="created[gt]") Integer createdgt, @Optional @DisplayName(value="limit") @Summary(value="A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 10.") Integer limit, @Optional @DisplayName(value="plan") @Summary(value="The ID of the plan whose subscriptions will be retrieved.") String plan, @Optional @DisplayName(value="created") Integer created, @ParameterGroup(name="Request Parameters") NonEntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        String requestPath = "/v1/subscriptions";
        RestRequestBuilder builder = new RestRequestBuilder(connection.getBaseUri(), requestPath, HttpConstants.Method.GET, (RequestParameters)parameters).setQueryParamFormat(QUERY_PARAM_FORMAT).addHeader("accept", "application/json").addQueryParam("ending_before", endingBefore).addQueryParam("collection_method", collectionMethod).addQueryParam("starting_after", startingAfter).addQueryParam("current_period_start", currentPeriodStart != null ? String.valueOf(currentPeriodStart) : null).addQueryParams("expand", expands.stream().filter(Objects::nonNull).map(v -> String.valueOf(v)).collect(Collectors.toList())).addQueryParam("status", status).addQueryParam("customer", customer).addQueryParam("current_period_end", currentPeriodEnd != null ? String.valueOf(currentPeriodEnd) : null).addQueryParam("created[gt]", createdgt != null ? String.valueOf(createdgt) : null).addQueryParam("limit", limit != null ? String.valueOf(limit) : null).addQueryParam("plan", plan).addQueryParam("created", created != null ? String.valueOf(created) : null);
        this.doRequest(config, connection, builder, overrides.getResponseTimeoutAsMillis(), streamingHelper, callback);
    }
}

