/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.providers.cas;

import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationException;
import net.sf.acegisecurity.BadCredentialsException;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.providers.AuthenticationProvider;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import net.sf.acegisecurity.providers.cas.CasAuthenticationToken;
import net.sf.acegisecurity.providers.cas.CasAuthoritiesPopulator;
import net.sf.acegisecurity.providers.cas.CasProxyDecider;
import net.sf.acegisecurity.providers.cas.StatelessTicketCache;
import net.sf.acegisecurity.providers.cas.TicketResponse;
import net.sf.acegisecurity.providers.cas.TicketValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class CasAuthenticationProvider
implements AuthenticationProvider,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$providers$cas$CasAuthenticationProvider == null ? (class$net$sf$acegisecurity$providers$cas$CasAuthenticationProvider = CasAuthenticationProvider.class$("net.sf.acegisecurity.providers.cas.CasAuthenticationProvider")) : class$net$sf$acegisecurity$providers$cas$CasAuthenticationProvider));
    private CasAuthoritiesPopulator casAuthoritiesPopulator;
    private CasProxyDecider casProxyDecider;
    private StatelessTicketCache statelessTicketCache;
    private String key;
    private TicketValidator ticketValidator;
    static /* synthetic */ Class class$net$sf$acegisecurity$providers$cas$CasAuthenticationProvider;
    static /* synthetic */ Class class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken;
    static /* synthetic */ Class class$net$sf$acegisecurity$providers$cas$CasAuthenticationToken;

    public void setCasAuthoritiesPopulator(CasAuthoritiesPopulator casAuthoritiesPopulator) {
        this.casAuthoritiesPopulator = casAuthoritiesPopulator;
    }

    public CasAuthoritiesPopulator getCasAuthoritiesPopulator() {
        return this.casAuthoritiesPopulator;
    }

    public void setCasProxyDecider(CasProxyDecider casProxyDecider) {
        this.casProxyDecider = casProxyDecider;
    }

    public CasProxyDecider getCasProxyDecider() {
        return this.casProxyDecider;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setStatelessTicketCache(StatelessTicketCache statelessTicketCache) {
        this.statelessTicketCache = statelessTicketCache;
    }

    public StatelessTicketCache getStatelessTicketCache() {
        return this.statelessTicketCache;
    }

    public void setTicketValidator(TicketValidator ticketValidator) {
        this.ticketValidator = ticketValidator;
    }

    public TicketValidator getTicketValidator() {
        return this.ticketValidator;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.casAuthoritiesPopulator == null) {
            throw new IllegalArgumentException("A casAuthoritiesPopulator must be set");
        }
        if (this.ticketValidator == null) {
            throw new IllegalArgumentException("A ticketValidator must be set");
        }
        if (this.casProxyDecider == null) {
            throw new IllegalArgumentException("A casProxyDecider must be set");
        }
        if (this.statelessTicketCache == null) {
            throw new IllegalArgumentException("A statelessTicketCache must be set");
        }
        if (this.key == null) {
            throw new IllegalArgumentException("A Key is required so CasAuthenticationProvider can identify tokens it previously authenticated");
        }
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!this.supports(authentication.getClass())) {
            return null;
        }
        if (authentication instanceof UsernamePasswordAuthenticationToken && !"_cas_stateful_".equals(authentication.getPrincipal().toString()) && !"_cas_stateless_".equals(authentication.getPrincipal().toString())) {
            return null;
        }
        if (authentication instanceof CasAuthenticationToken) {
            if (this.key.hashCode() == ((CasAuthenticationToken)authentication).getKeyHash()) {
                return authentication;
            }
            throw new BadCredentialsException("The presented CasAuthenticationToken does not contain the expected key");
        }
        if (authentication.getCredentials() == null || "".equals(authentication.getCredentials())) {
            throw new BadCredentialsException("Failed to provide a CAS service ticket to validate");
        }
        boolean stateless = false;
        if (authentication instanceof UsernamePasswordAuthenticationToken && "_cas_stateless_".equals(authentication.getPrincipal())) {
            stateless = true;
        }
        CasAuthenticationToken result = null;
        if (stateless) {
            result = this.statelessTicketCache.getByTicketId(authentication.getCredentials().toString());
        }
        if (result == null) {
            result = this.authenticateNow(authentication);
        }
        if (stateless) {
            this.statelessTicketCache.putTicketInCache(result);
        }
        return result;
    }

    public boolean supports(Class authentication) {
        if ((class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken == null ? (class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken = CasAuthenticationProvider.class$("net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken")) : class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken).isAssignableFrom(authentication)) {
            return true;
        }
        return (class$net$sf$acegisecurity$providers$cas$CasAuthenticationToken == null ? (class$net$sf$acegisecurity$providers$cas$CasAuthenticationToken = CasAuthenticationProvider.class$("net.sf.acegisecurity.providers.cas.CasAuthenticationToken")) : class$net$sf$acegisecurity$providers$cas$CasAuthenticationToken).isAssignableFrom(authentication);
    }

    private CasAuthenticationToken authenticateNow(Authentication authentication) throws AuthenticationException {
        TicketResponse response = this.ticketValidator.confirmTicketValid(authentication.getCredentials().toString());
        this.casProxyDecider.confirmProxyListTrusted(response.getProxyList());
        GrantedAuthority[] ga = this.casAuthoritiesPopulator.getAuthorities(response.getUser());
        return new CasAuthenticationToken(this.key, response.getUser(), authentication.getCredentials(), ga, response.getProxyList(), response.getProxyGrantingTicketIou());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

