/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.providers.dao;

import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationException;
import net.sf.acegisecurity.AuthenticationServiceException;
import net.sf.acegisecurity.BadCredentialsException;
import net.sf.acegisecurity.DisabledException;
import net.sf.acegisecurity.providers.AuthenticationProvider;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import net.sf.acegisecurity.providers.dao.AuthenticationDao;
import net.sf.acegisecurity.providers.dao.SaltSource;
import net.sf.acegisecurity.providers.dao.User;
import net.sf.acegisecurity.providers.dao.UserCache;
import net.sf.acegisecurity.providers.dao.UsernameNotFoundException;
import net.sf.acegisecurity.providers.dao.cache.NullUserCache;
import net.sf.acegisecurity.providers.dao.event.AuthenticationFailureDisabledEvent;
import net.sf.acegisecurity.providers.dao.event.AuthenticationFailurePasswordEvent;
import net.sf.acegisecurity.providers.dao.event.AuthenticationSuccessEvent;
import net.sf.acegisecurity.providers.encoding.PasswordEncoder;
import net.sf.acegisecurity.providers.encoding.PlaintextPasswordEncoder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.dao.DataAccessException;

public class DaoAuthenticationProvider
implements AuthenticationProvider,
InitializingBean,
ApplicationContextAware {
    private ApplicationContext ctx;
    private AuthenticationDao authenticationDao;
    private PasswordEncoder passwordEncoder = new PlaintextPasswordEncoder();
    private SaltSource saltSource;
    private UserCache userCache = new NullUserCache();
    static /* synthetic */ Class class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ctx = applicationContext;
    }

    public void setAuthenticationDao(AuthenticationDao authenticationDao) {
        this.authenticationDao = authenticationDao;
    }

    public AuthenticationDao getAuthenticationDao() {
        return this.authenticationDao;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public void setSaltSource(SaltSource saltSource) {
        this.saltSource = saltSource;
    }

    public SaltSource getSaltSource() {
        return this.saltSource;
    }

    public void setUserCache(UserCache userCache) {
        this.userCache = userCache;
    }

    public UserCache getUserCache() {
        return this.userCache;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.authenticationDao == null) {
            throw new IllegalArgumentException("An Authentication DAO must be set");
        }
        if (this.userCache == null) {
            throw new IllegalArgumentException("A user cache must be set");
        }
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        boolean cacheWasUsed = true;
        User user = this.userCache.getUserFromCache(authentication.getPrincipal().toString());
        if (user == null) {
            cacheWasUsed = false;
            user = this.getUserFromBackend(authentication);
        }
        if (!user.isEnabled()) {
            if (this.ctx != null) {
                this.ctx.publishEvent((ApplicationEvent)new AuthenticationFailureDisabledEvent(authentication, user));
            }
            throw new DisabledException("User is disabled");
        }
        if (!this.isPasswordCorrect(authentication, user)) {
            if (cacheWasUsed) {
                cacheWasUsed = false;
                user = this.getUserFromBackend(authentication);
            }
            if (!this.isPasswordCorrect(authentication, user)) {
                if (this.ctx != null) {
                    this.ctx.publishEvent((ApplicationEvent)new AuthenticationFailurePasswordEvent(authentication, user));
                }
                throw new BadCredentialsException("Bad credentials presented");
            }
        }
        if (!cacheWasUsed) {
            this.userCache.putUserInCache(user);
            if (this.ctx != null) {
                this.ctx.publishEvent((ApplicationEvent)new AuthenticationSuccessEvent(authentication, user));
            }
        }
        return new UsernamePasswordAuthenticationToken(user.getUsername(), user.getPassword(), user.getAuthorities());
    }

    public boolean supports(Class authentication) {
        return (class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken == null ? (class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken = DaoAuthenticationProvider.class$("net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken")) : class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken).isAssignableFrom(authentication);
    }

    private boolean isPasswordCorrect(Authentication authentication, User user) {
        Object salt = null;
        if (this.saltSource != null) {
            salt = this.saltSource.getSalt(user);
        }
        return this.passwordEncoder.isPasswordValid(user.getPassword(), authentication.getCredentials().toString(), salt);
    }

    private User getUserFromBackend(Authentication authentication) {
        try {
            return this.authenticationDao.loadUserByUsername(authentication.getPrincipal().toString());
        }
        catch (UsernameNotFoundException notFound) {
            throw new BadCredentialsException("Bad credentials presented");
        }
        catch (DataAccessException repositoryProblem) {
            throw new AuthenticationServiceException(repositoryProblem.getMessage(), repositoryProblem);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

