/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.securechannel;

import java.io.IOException;
import java.util.Iterator;
import javax.servlet.ServletException;
import net.sf.acegisecurity.ConfigAttribute;
import net.sf.acegisecurity.ConfigAttributeDefinition;
import net.sf.acegisecurity.intercept.web.FilterInvocation;
import net.sf.acegisecurity.securechannel.ChannelEntryPoint;
import net.sf.acegisecurity.securechannel.ChannelProcessor;
import net.sf.acegisecurity.securechannel.RetryWithHttpsEntryPoint;
import org.springframework.beans.factory.InitializingBean;

public class SecureChannelProcessor
implements InitializingBean,
ChannelProcessor {
    private ChannelEntryPoint entryPoint = new RetryWithHttpsEntryPoint();
    private String secureKeyword = "REQUIRES_SECURE_CHANNEL";

    public void setEntryPoint(ChannelEntryPoint entryPoint) {
        this.entryPoint = entryPoint;
    }

    public ChannelEntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    public void setSecureKeyword(String secureKeyword) {
        this.secureKeyword = secureKeyword;
    }

    public String getSecureKeyword() {
        return this.secureKeyword;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.secureKeyword == null || "".equals(this.secureKeyword)) {
            throw new IllegalArgumentException("secureKeyword required");
        }
        if (this.entryPoint == null) {
            throw new IllegalArgumentException("entryPoint required");
        }
    }

    public void decide(FilterInvocation invocation, ConfigAttributeDefinition config) throws IOException, ServletException {
        if (invocation == null || config == null) {
            throw new IllegalArgumentException("Nulls cannot be provided");
        }
        Iterator iter = config.getConfigAttributes();
        while (iter.hasNext()) {
            ConfigAttribute attribute = (ConfigAttribute)iter.next();
            if (!this.supports(attribute) || invocation.getHttpRequest().isSecure()) continue;
            this.entryPoint.commence(invocation.getRequest(), invocation.getResponse());
        }
    }

    public boolean supports(ConfigAttribute attribute) {
        return attribute != null && attribute.getAttribute() != null && attribute.getAttribute().equals(this.getSecureKeyword());
    }
}

