/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.ui.webapp;

import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationException;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import net.sf.acegisecurity.ui.AbstractProcessingFilter;

public class AuthenticationProcessingFilter
extends AbstractProcessingFilter {
    public static final String ACEGI_SECURITY_FORM_USERNAME_KEY = "j_username";
    public static final String ACEGI_SECURITY_FORM_PASSWORD_KEY = "j_password";

    public String getDefaultFilterProcessesUrl() {
        return "/j_acegi_security_check";
    }

    public Authentication attemptAuthentication(HttpServletRequest request) throws AuthenticationException {
        String username = request.getParameter(ACEGI_SECURITY_FORM_USERNAME_KEY);
        String password = request.getParameter(ACEGI_SECURITY_FORM_PASSWORD_KEY);
        if (username == null) {
            username = "";
        }
        if (password == null) {
            password = "";
        }
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken(username, password);
        authRequest.setDetails(request.getRemoteAddr());
        return this.getAuthenticationManager().authenticate(authRequest);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

