/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.util;

import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class FilterToBeanProxy
implements Filter {
    private Filter delegate;

    public void destroy() {
        this.delegate.destroy();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.delegate.doFilter(request, response, chain);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String targetBean = filterConfig.getInitParameter("targetBean");
        if ("".equals(targetBean)) {
            targetBean = null;
        }
        ApplicationContext ctx = this.getContext(filterConfig);
        String beanName = null;
        if (targetBean != null && ctx.containsBean(targetBean)) {
            beanName = targetBean;
        } else {
            Class<?> targetClass;
            if (targetBean != null) {
                throw new ServletException("targetBean '" + targetBean + "' not found in context");
            }
            String targetClassString = filterConfig.getInitParameter("targetClass");
            if (targetClassString == null || "".equals(targetClassString)) {
                throw new ServletException("targetClass or targetBean must be specified");
            }
            try {
                targetClass = Thread.currentThread().getContextClassLoader().loadClass(targetClassString);
            }
            catch (ClassNotFoundException ex) {
                throw new ServletException("Class of type " + targetClassString + " not found in classloader");
            }
            Map beans = ctx.getBeansOfType(targetClass, true, true);
            if (beans.size() == 0) {
                throw new ServletException("Bean context must contain at least one bean of type " + targetClassString);
            }
            beanName = (String)beans.keySet().iterator().next();
        }
        Object object = ctx.getBean(beanName);
        if (!(object instanceof Filter)) {
            throw new ServletException("Bean '" + beanName + "' does not implement javax.servlet.Filter");
        }
        this.delegate = (Filter)object;
        this.delegate.init(filterConfig);
    }

    protected ApplicationContext getContext(FilterConfig filterConfig) {
        return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)filterConfig.getServletContext());
    }
}

