/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.providers.dao.cache;

import java.io.Serializable;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.providers.dao.UserCache;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataRetrievalFailureException;

public class EhCacheBasedUserCache
implements UserCache,
InitializingBean,
DisposableBean {
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$providers$dao$cache$EhCacheBasedUserCache == null ? (class$net$sf$acegisecurity$providers$dao$cache$EhCacheBasedUserCache = EhCacheBasedUserCache.class$("net.sf.acegisecurity.providers.dao.cache.EhCacheBasedUserCache")) : class$net$sf$acegisecurity$providers$dao$cache$EhCacheBasedUserCache));
    private static final String CACHE_NAME = "ehCacheBasedUserCache";
    private Cache cache;
    private CacheManager manager;
    private int minutesToIdle = 5;
    static /* synthetic */ Class class$net$sf$acegisecurity$providers$dao$cache$EhCacheBasedUserCache;

    public void setMinutesToIdle(int minutesToIdle) {
        this.minutesToIdle = minutesToIdle;
    }

    public int getMinutesToIdle() {
        return this.minutesToIdle;
    }

    public UserDetails getUserFromCache(String username) {
        Element element = null;
        try {
            element = this.cache.get((Serializable)((Object)username));
        }
        catch (CacheException cacheException) {
            throw new DataRetrievalFailureException("Cache failure: " + cacheException.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache hit: " + (element != null) + "; username: " + username));
        }
        if (element == null) {
            return null;
        }
        return (UserDetails)element.getValue();
    }

    public void afterPropertiesSet() throws Exception {
        if (CacheManager.getInstance().cacheExists(CACHE_NAME)) {
            this.cache = CacheManager.getInstance().getCache(CACHE_NAME);
        } else {
            this.manager = CacheManager.create();
            this.cache = new Cache(CACHE_NAME, Integer.MAX_VALUE, false, false, (long)(this.minutesToIdle * 60), (long)(this.minutesToIdle * 60));
            this.manager.addCache(this.cache);
        }
    }

    public void destroy() throws Exception {
        this.manager.removeCache(CACHE_NAME);
    }

    public void putUserInCache(UserDetails user) {
        Element element = new Element((Serializable)((Object)user.getUsername()), (Serializable)user);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache put: " + element.getKey()));
        }
        this.cache.put(element);
    }

    public void removeUserFromCache(UserDetails user) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache remove: " + user.getUsername()));
        }
        this.removeUserFromCache(user.getUsername());
    }

    public void removeUserFromCache(String username) {
        this.cache.remove((Serializable)((Object)username));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

