/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.intercept;

import java.util.HashSet;
import java.util.Iterator;
import net.sf.acegisecurity.AccessDecisionManager;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationCredentialsNotFoundException;
import net.sf.acegisecurity.AuthenticationManager;
import net.sf.acegisecurity.ConfigAttribute;
import net.sf.acegisecurity.ConfigAttributeDefinition;
import net.sf.acegisecurity.RunAsManager;
import net.sf.acegisecurity.context.ContextHolder;
import net.sf.acegisecurity.context.SecureContext;
import net.sf.acegisecurity.intercept.ObjectDefinitionSource;
import net.sf.acegisecurity.intercept.SecurityInterceptorCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractSecurityInterceptor
implements InitializingBean {
    protected static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$intercept$AbstractSecurityInterceptor == null ? (class$net$sf$acegisecurity$intercept$AbstractSecurityInterceptor = AbstractSecurityInterceptor.class$("net.sf.acegisecurity.intercept.AbstractSecurityInterceptor")) : class$net$sf$acegisecurity$intercept$AbstractSecurityInterceptor));
    private AccessDecisionManager accessDecisionManager;
    private AuthenticationManager authenticationManager;
    private RunAsManager runAsManager;
    private boolean validateConfigAttributes = true;
    static /* synthetic */ Class class$net$sf$acegisecurity$intercept$AbstractSecurityInterceptor;

    public abstract ObjectDefinitionSource obtainObjectDefinitionSource();

    public void setAccessDecisionManager(AccessDecisionManager accessDecisionManager) {
        this.accessDecisionManager = accessDecisionManager;
    }

    public AccessDecisionManager getAccessDecisionManager() {
        return this.accessDecisionManager;
    }

    public void setAuthenticationManager(AuthenticationManager newManager) {
        this.authenticationManager = newManager;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setRunAsManager(RunAsManager runAsManager) {
        this.runAsManager = runAsManager;
    }

    public RunAsManager getRunAsManager() {
        return this.runAsManager;
    }

    public void setValidateConfigAttributes(boolean validateConfigAttributes) {
        this.validateConfigAttributes = validateConfigAttributes;
    }

    public boolean isValidateConfigAttributes() {
        return this.validateConfigAttributes;
    }

    public void afterPropertiesSet() {
        if (this.authenticationManager == null) {
            throw new IllegalArgumentException("An AuthenticationManager is required");
        }
        if (this.accessDecisionManager == null) {
            throw new IllegalArgumentException("An AccessDecisionManager is required");
        }
        if (this.runAsManager == null) {
            throw new IllegalArgumentException("A RunAsManager is required");
        }
        if (this.obtainObjectDefinitionSource() == null) {
            throw new IllegalArgumentException("An ObjectDefinitionSource is required");
        }
        if (this.validateConfigAttributes) {
            Iterator iter = this.obtainObjectDefinitionSource().getConfigAttributeDefinitions();
            if (iter == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)"Could not validate configuration attributes as the MethodDefinitionSource did not return a ConfigAttributeDefinition Iterator");
                }
                return;
            }
            HashSet<ConfigAttribute> set = new HashSet<ConfigAttribute>();
            while (iter.hasNext()) {
                ConfigAttributeDefinition def = (ConfigAttributeDefinition)iter.next();
                Iterator attributes = def.getConfigAttributes();
                while (attributes.hasNext()) {
                    ConfigAttribute attr = (ConfigAttribute)attributes.next();
                    if (this.runAsManager.supports(attr) || this.accessDecisionManager.supports(attr)) continue;
                    set.add(attr);
                }
            }
            if (set.size() == 0) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Validated configuration attributes");
                }
            } else {
                throw new IllegalArgumentException("Unsupported configuration attributes: " + ((Object)set).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object interceptor(Object object, SecurityInterceptorCallback callback) throws Throwable {
        SecureContext context;
        if (object == null) {
            throw new IllegalArgumentException("Object was null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Callback was null");
        }
        if (!this.obtainObjectDefinitionSource().supports(object.getClass())) {
            throw new IllegalArgumentException("ObjectDefinitionSource does not support objects of type " + object.getClass());
        }
        ConfigAttributeDefinition attr = this.obtainObjectDefinitionSource().getAttributes(object);
        if (attr != null) {
            Object object2;
            Authentication runAs;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Secure object: " + object.toString() + "; ConfigAttributes: " + attr.toString()));
            }
            if (ContextHolder.getContext() == null || !(ContextHolder.getContext() instanceof SecureContext)) {
                throw new AuthenticationCredentialsNotFoundException("A valid SecureContext was not provided in the RequestContext");
            }
            SecureContext context2 = (SecureContext)ContextHolder.getContext();
            if (context2.getAuthentication() == null) {
                throw new AuthenticationCredentialsNotFoundException("Authentication credentials were not found in the SecureContext");
            }
            Authentication authenticated = this.authenticationManager.authenticate(context2.getAuthentication());
            authenticated.setAuthenticated(true);
            logger.debug((Object)("Authenticated: " + authenticated.toString()));
            context2.setAuthentication(authenticated);
            ContextHolder.setContext(context2);
            this.accessDecisionManager.decide(authenticated, object, attr);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Authorization successful");
            }
            if ((runAs = this.runAsManager.buildRunAs(authenticated, object, attr)) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"RunAsManager did not change Authentication object");
                }
                return callback.proceedWithObject(object);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Switching to RunAs Authentication: " + runAs.toString()));
            }
            SecureContext origSecureContext = null;
            try {
                origSecureContext = (SecureContext)ContextHolder.getContext();
                context2.setAuthentication(runAs);
                ContextHolder.setContext(context2);
                object2 = callback.proceedWithObject(object);
                Object var10_11 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Reverting to original Authentication: " + authenticated.toString()));
                }
                origSecureContext.setAuthentication(authenticated);
                ContextHolder.setContext(origSecureContext);
                throw throwable;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Reverting to original Authentication: " + authenticated.toString()));
            }
            origSecureContext.setAuthentication(authenticated);
            ContextHolder.setContext(origSecureContext);
            return object2;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Public object - authentication not attempted");
        }
        if (ContextHolder.getContext() != null && ContextHolder.getContext() instanceof SecureContext && (context = (SecureContext)ContextHolder.getContext()).getAuthentication() != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Authentication object detected and tagged as unauthenticated");
            }
            Authentication authenticated = context.getAuthentication();
            authenticated.setAuthenticated(false);
            context.setAuthentication(authenticated);
            ContextHolder.setContext(context);
        }
        return callback.proceedWithObject(object);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

