/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.providers.cas.cache;

import java.io.Serializable;
import net.sf.acegisecurity.providers.cas.CasAuthenticationToken;
import net.sf.acegisecurity.providers.cas.StatelessTicketCache;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataRetrievalFailureException;

public class EhCacheBasedTicketCache
implements StatelessTicketCache,
InitializingBean {
    private Cache cache;
    private CacheManager manager;
    private int minutesToIdle = 20;

    public CasAuthenticationToken getByTicketId(String serviceTicket) {
        Element element = null;
        try {
            element = this.cache.get((Serializable)((Object)serviceTicket));
        }
        catch (CacheException cacheException) {
            throw new DataRetrievalFailureException("Cache failure: " + cacheException.getMessage());
        }
        if (element == null) {
            System.out.println("not found");
            return null;
        }
        System.out.println("found");
        return (CasAuthenticationToken)element.getValue();
    }

    public void setMinutesToIdle(int minutesToIdle) {
        this.minutesToIdle = minutesToIdle;
    }

    public int getMinutesToIdle() {
        return this.minutesToIdle;
    }

    public void afterPropertiesSet() throws Exception {
        this.manager = CacheManager.create();
        this.cache = new Cache("ehCacheBasedTicketCache", Integer.MAX_VALUE, false, false, (long)(this.minutesToIdle * 60), (long)(this.minutesToIdle * 60));
        this.manager.addCache(this.cache);
    }

    public void putTicketInCache(CasAuthenticationToken token) {
        Element element = new Element((Serializable)((Object)token.getCredentials().toString()), (Serializable)token);
        System.out.println("Adding " + element.getKey());
        this.cache.put(element);
    }

    public void removeTicketFromCache(CasAuthenticationToken token) {
        this.removeTicketFromCache(token.getCredentials().toString());
    }

    public void removeTicketFromCache(String serviceTicket) {
        this.cache.remove((Serializable)((Object)serviceTicket));
    }
}

