/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.providers.dao;

import java.util.Date;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationException;
import net.sf.acegisecurity.AuthenticationServiceException;
import net.sf.acegisecurity.BadCredentialsException;
import net.sf.acegisecurity.DisabledException;
import net.sf.acegisecurity.providers.AuthenticationProvider;
import net.sf.acegisecurity.providers.dao.AuthenticationDao;
import net.sf.acegisecurity.providers.dao.DaoAuthenticationToken;
import net.sf.acegisecurity.providers.dao.SaltSource;
import net.sf.acegisecurity.providers.dao.User;
import net.sf.acegisecurity.providers.dao.UsernameNotFoundException;
import net.sf.acegisecurity.providers.encoding.PasswordEncoder;
import net.sf.acegisecurity.providers.encoding.PlaintextPasswordEncoder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;

public class DaoAuthenticationProvider
implements AuthenticationProvider,
InitializingBean {
    private AuthenticationDao authenticationDao;
    private PasswordEncoder passwordEncoder = new PlaintextPasswordEncoder();
    private SaltSource saltSource;
    private String key;
    private long refreshTokenInterval = 60000L;
    static /* synthetic */ Class class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken;
    static /* synthetic */ Class class$net$sf$acegisecurity$providers$dao$DaoAuthenticationToken;

    public void setAuthenticationDao(AuthenticationDao authenticationDao) {
        this.authenticationDao = authenticationDao;
    }

    public AuthenticationDao getAuthenticationDao() {
        return this.authenticationDao;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public void setRefreshTokenInterval(long refreshTokenInterval) {
        this.refreshTokenInterval = refreshTokenInterval;
    }

    public long getRefreshTokenInterval() {
        return this.refreshTokenInterval;
    }

    public void setSaltSource(SaltSource saltSource) {
        this.saltSource = saltSource;
    }

    public SaltSource getSaltSource() {
        return this.saltSource;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.authenticationDao == null) {
            throw new IllegalArgumentException("An Authentication DAO must be set");
        }
        if (this.key == null || "".equals(this.key)) {
            throw new IllegalArgumentException("A key must be set");
        }
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (authentication instanceof DaoAuthenticationToken) {
            if (this.key.hashCode() == ((DaoAuthenticationToken)authentication).getKeyHash()) {
                if (((DaoAuthenticationToken)authentication).getExpires().after(new Date())) {
                    return authentication;
                }
            } else {
                throw new BadCredentialsException("The presented DaoAuthenticationToken does not contain the expected key");
            }
        }
        User user = null;
        try {
            user = this.authenticationDao.loadUserByUsername(authentication.getPrincipal().toString());
        }
        catch (UsernameNotFoundException notFound) {
            throw new BadCredentialsException("Bad credentials presented");
        }
        catch (DataAccessException repositoryProblem) {
            throw new AuthenticationServiceException(repositoryProblem.getMessage(), repositoryProblem);
        }
        if (!(authentication instanceof DaoAuthenticationToken)) {
            Object salt = null;
            if (this.saltSource != null) {
                salt = this.saltSource.getSalt(user);
            }
            if (!this.passwordEncoder.isPasswordValid(user.getPassword(), authentication.getCredentials().toString(), salt)) {
                throw new BadCredentialsException("Bad credentials presented");
            }
        }
        if (!user.isEnabled()) {
            throw new DisabledException("User is disabled");
        }
        Date expiry = new Date(new Date().getTime() + this.getRefreshTokenInterval());
        return new DaoAuthenticationToken(this.getKey(), expiry, user.getUsername(), user.getPassword(), user.getAuthorities());
    }

    public boolean supports(Class authentication) {
        return (class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken == null ? (class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken = DaoAuthenticationProvider.class$("net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken")) : class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken).isAssignableFrom(authentication) || (class$net$sf$acegisecurity$providers$dao$DaoAuthenticationToken == null ? (class$net$sf$acegisecurity$providers$dao$DaoAuthenticationToken = DaoAuthenticationProvider.class$("net.sf.acegisecurity.providers.dao.DaoAuthenticationToken")) : class$net$sf$acegisecurity$providers$dao$DaoAuthenticationToken).isAssignableFrom(authentication);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

