/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.providers.dao;

import java.io.Serializable;
import java.util.Date;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.providers.AbstractAuthenticationToken;

public class DaoAuthenticationToken
extends AbstractAuthenticationToken
implements Serializable {
    private Date expires;
    private Object credentials;
    private Object principal;
    private GrantedAuthority[] authorities;
    private int keyHash;

    public DaoAuthenticationToken(String key, Date expires, Object principal, Object credentials, GrantedAuthority[] authorities) {
        if (key == null || "".equals(key) || expires == null || principal == null || "".equals(principal) || credentials == null || "".equals(credentials) || authorities == null) {
            throw new IllegalArgumentException("Cannot pass null or empty values to constructor");
        }
        for (int i = 0; i < authorities.length; ++i) {
            if (authorities[i] != null) continue;
            throw new IllegalArgumentException("Granted authority element " + i + " is null - GrantedAuthority[] cannot contain any null elements");
        }
        this.keyHash = key.hashCode();
        this.expires = expires;
        this.principal = principal;
        this.credentials = credentials;
        this.authorities = authorities;
    }

    protected DaoAuthenticationToken() {
        throw new IllegalArgumentException("Cannot use default constructor");
    }

    public void setAuthenticated(boolean isAuthenticated) {
    }

    public boolean isAuthenticated() {
        return true;
    }

    public GrantedAuthority[] getAuthorities() {
        return this.authorities;
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public Date getExpires() {
        return this.expires;
    }

    public int getKeyHash() {
        return this.keyHash;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof DaoAuthenticationToken) {
            DaoAuthenticationToken test = (DaoAuthenticationToken)obj;
            if (this.getKeyHash() != test.getKeyHash()) {
                return false;
            }
            return this.getExpires() == test.getExpires();
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("; Expires: " + this.expires.toString());
        return sb.toString();
    }
}

