/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.ui;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.context.ContextHolder;
import net.sf.acegisecurity.context.SecureContext;
import net.sf.acegisecurity.context.SecureContextImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractIntegrationFilter
implements Filter {
    protected static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$ui$AbstractIntegrationFilter == null ? (class$net$sf$acegisecurity$ui$AbstractIntegrationFilter = AbstractIntegrationFilter.class$("net.sf.acegisecurity.ui.AbstractIntegrationFilter")) : class$net$sf$acegisecurity$ui$AbstractIntegrationFilter));
    static /* synthetic */ Class class$net$sf$acegisecurity$ui$AbstractIntegrationFilter;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object extracted = this.extractFromContainer(request);
        if (extracted instanceof Authentication) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Authentication added to ContextHolder from container");
            }
            Authentication auth = (Authentication)extracted;
            SecureContext secureContext = null;
            secureContext = ContextHolder.getContext() == null || !(ContextHolder.getContext() instanceof SecureContext) ? new SecureContextImpl() : (SecureContext)ContextHolder.getContext();
            secureContext.setAuthentication(auth);
            ContextHolder.setContext(secureContext);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"Authentication not added to ContextHolder (could not extract an authentication object from the container which is an instance of Authentication)");
        }
        chain.doFilter(request, response);
        if (ContextHolder.getContext() != null && ContextHolder.getContext() instanceof SecureContext) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Removing Authentication from ContextHolder");
            }
            SecureContext secureContext = (SecureContext)ContextHolder.getContext();
            secureContext.setAuthentication(null);
            ContextHolder.setContext(secureContext);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"ContextHolder does not contain any authentication information");
        }
    }

    public abstract Object extractFromContainer(ServletRequest var1);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

