/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.adapters.jboss;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationException;
import net.sf.acegisecurity.AuthenticationManager;
import net.sf.acegisecurity.adapters.PrincipalAcegiUserToken;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class JbossAcegiLoginModule
extends AbstractServerLoginModule {
    private AuthenticationManager authenticationManager;
    private Principal identity;
    private String key;
    private char[] credential;
    static /* synthetic */ Class class$net$sf$acegisecurity$AuthenticationManager;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.key = (String)options.get("key");
        if (this.key == null || "".equals(this.key)) {
            throw new IllegalArgumentException("key must be defined");
        }
        String appContextLocation = (String)options.get("appContextLocation");
        if (appContextLocation == null || "".equals(appContextLocation)) {
            throw new IllegalArgumentException("appContextLocation must be defined");
        }
        if (Thread.currentThread().getContextClassLoader().getResource(appContextLocation) == null) {
            throw new IllegalArgumentException("Cannot locate " + appContextLocation);
        }
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(appContextLocation);
        Map beans = ctx.getBeansOfType(class$net$sf$acegisecurity$AuthenticationManager == null ? (class$net$sf$acegisecurity$AuthenticationManager = JbossAcegiLoginModule.class$("net.sf.acegisecurity.AuthenticationManager")) : class$net$sf$acegisecurity$AuthenticationManager, true, true);
        if (beans.size() == 0) {
            throw new IllegalArgumentException("Bean context must contain at least one bean of type AuthenticationManager");
        }
        String beanName = (String)beans.keySet().iterator().next();
        this.authenticationManager = (AuthenticationManager)beans.get(beanName);
        this.log.info((Object)"Successfully started JbossSpringLoginModule");
    }

    public boolean login() throws LoginException {
        this.loginOk = false;
        String[] info = this.getUsernameAndPassword();
        String username = info[0];
        String password = info[1];
        if (username == null && password == null) {
            this.identity = null;
            this.log.trace((Object)("Authenticating as unauthenticatedIdentity=" + this.identity));
        }
        if (username == null) {
            username = "";
        }
        if (password == null) {
            password = "";
        }
        if (this.identity == null) {
            UsernamePasswordAuthenticationToken request = new UsernamePasswordAuthenticationToken(username, password);
            Authentication response = null;
            try {
                response = this.authenticationManager.authenticate(request);
            }
            catch (AuthenticationException failed) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Bad password for username=" + username));
                }
                throw new FailedLoginException("Password Incorrect/Password Required");
            }
            this.identity = new PrincipalAcegiUserToken(this.key, response.getPrincipal().toString(), response.getCredentials().toString(), response.getAuthorities());
        }
        if (this.getUseFirstPass()) {
            this.sharedState.put("javax.security.auth.login.name", username);
            this.sharedState.put("javax.security.auth.login.password", this.credential);
        }
        this.loginOk = true;
        this.log.trace((Object)("User '" + this.identity + "' authenticated, loginOk=" + this.loginOk));
        return true;
    }

    protected Principal getIdentity() {
        return this.identity;
    }

    protected Group[] getRoleSets() throws LoginException {
        SimpleGroup roles = new SimpleGroup("Roles");
        Group[] roleSets = new Group[]{roles};
        if (this.identity instanceof Authentication) {
            Authentication user = (Authentication)this.identity;
            for (int i = 0; i < user.getAuthorities().length; ++i) {
                roles.addMember((Principal)new SimplePrincipal(user.getAuthorities()[i].getAuthority()));
            }
        }
        return roleSets;
    }

    protected String[] getUsernameAndPassword() throws LoginException {
        String[] info = new String[]{null, null};
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to collect authentication information");
        }
        NameCallback nc = new NameCallback("User name: ", "guest");
        PasswordCallback pc = new PasswordCallback("Password: ", false);
        Callback[] callbacks = new Callback[]{nc, pc};
        String username = null;
        String password = null;
        try {
            this.callbackHandler.handle(callbacks);
            username = nc.getName();
            char[] tmpPassword = pc.getPassword();
            if (tmpPassword != null) {
                this.credential = new char[tmpPassword.length];
                System.arraycopy(tmpPassword, 0, this.credential, 0, tmpPassword.length);
                pc.clearPassword();
                password = new String(this.credential);
            }
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("CallbackHandler does not support: " + uce.getCallback());
        }
        info[0] = username;
        info[1] = password;
        return info;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

