/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.providers.cas;

import java.io.Serializable;
import java.util.List;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.providers.AbstractAuthenticationToken;

public class CasAuthenticationToken
extends AbstractAuthenticationToken
implements Serializable {
    private List proxyList;
    private Object credentials;
    private Object principal;
    private String proxyGrantingTicketIou;
    private GrantedAuthority[] authorities;
    private int keyHash;

    public CasAuthenticationToken(String key, Object principal, Object credentials, GrantedAuthority[] authorities, List proxyList, String proxyGrantingTicketIou) {
        if (key == null || "".equals(key) || principal == null || "".equals(principal) || credentials == null || "".equals(credentials) || authorities == null || proxyList == null || proxyGrantingTicketIou == null || "".equals(proxyGrantingTicketIou)) {
            throw new IllegalArgumentException("Cannot pass null or empty values to constructor");
        }
        for (int i = 0; i < authorities.length; ++i) {
            if (authorities[i] != null) continue;
            throw new IllegalArgumentException("Granted authority element " + i + " is null - GrantedAuthority[] cannot contain any null elements");
        }
        this.keyHash = key.hashCode();
        this.principal = principal;
        this.credentials = credentials;
        this.authorities = authorities;
        this.proxyList = proxyList;
        this.proxyGrantingTicketIou = proxyGrantingTicketIou;
    }

    protected CasAuthenticationToken() {
        throw new IllegalArgumentException("Cannot use default constructor");
    }

    public void setAuthenticated(boolean isAuthenticated) {
    }

    public boolean isAuthenticated() {
        return true;
    }

    public GrantedAuthority[] getAuthorities() {
        return this.authorities;
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public int getKeyHash() {
        return this.keyHash;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public String getProxyGrantingTicketIou() {
        return this.proxyGrantingTicketIou;
    }

    public List getProxyList() {
        return this.proxyList;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof CasAuthenticationToken) {
            CasAuthenticationToken test = (CasAuthenticationToken)obj;
            if (!this.getProxyGrantingTicketIou().equals(test.getProxyGrantingTicketIou())) {
                return false;
            }
            if (!((Object)this.getProxyList()).equals(test.getProxyList())) {
                return false;
            }
            return this.getKeyHash() == test.getKeyHash();
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("; Credentials (Service/Proxy Ticket): " + this.credentials);
        sb.append("; Proxy-Granting Ticket IOU: " + this.proxyGrantingTicketIou);
        sb.append("; Proxy List: " + this.proxyList.toString());
        return sb.toString();
    }
}

