/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.taglibs.authz;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.GrantedAuthorityImpl;
import net.sf.acegisecurity.context.ContextHolder;
import net.sf.acegisecurity.context.SecureContext;
import org.springframework.web.util.ExpressionEvaluationUtils;

public class AuthorizeTag
extends TagSupport {
    private String ifAllGranted = "";
    private String ifAnyGranted = "";
    private String ifNotGranted = "";

    public void setIfAllGranted(String ifAllGranted) throws JspException {
        this.ifAllGranted = ifAllGranted;
    }

    public String getIfAllGranted() {
        return this.ifAllGranted;
    }

    public void setIfAnyGranted(String ifAnyGranted) throws JspException {
        this.ifAnyGranted = ifAnyGranted;
    }

    public String getIfAnyGranted() {
        return this.ifAnyGranted;
    }

    public void setIfNotGranted(String ifNotGranted) throws JspException {
        this.ifNotGranted = ifNotGranted;
    }

    public String getIfNotGranted() {
        return this.ifNotGranted;
    }

    public int doStartTag() throws JspException {
        Set grantedCopy;
        Set grantedCopy2;
        if (!(null != this.ifAllGranted && !"".equals(this.ifAllGranted) || null != this.ifAnyGranted && !"".equals(this.ifAnyGranted) || null != this.ifNotGranted && !"".equals(this.ifNotGranted))) {
            return 0;
        }
        Collection granted = this.getPrincipalAuthorities();
        String evaledIfNotGranted = ExpressionEvaluationUtils.evaluateString((String)"ifNotGranted", (String)this.ifNotGranted, (PageContext)this.pageContext);
        if (null != evaledIfNotGranted && !"".equals(evaledIfNotGranted) && !(grantedCopy2 = this.retainAll(granted, this.parseAuthoritiesString(evaledIfNotGranted))).isEmpty()) {
            return 0;
        }
        String evaledIfAllGranted = ExpressionEvaluationUtils.evaluateString((String)"ifAllGranted", (String)this.ifAllGranted, (PageContext)this.pageContext);
        if (null != evaledIfAllGranted && !"".equals(evaledIfAllGranted) && !granted.containsAll(this.parseAuthoritiesString(evaledIfAllGranted))) {
            return 0;
        }
        String evaledIfAnyGranted = ExpressionEvaluationUtils.evaluateString((String)"ifAnyGranted", (String)this.ifAnyGranted, (PageContext)this.pageContext);
        if (null != evaledIfAnyGranted && !"".equals(evaledIfAnyGranted) && (grantedCopy = this.retainAll(granted, this.parseAuthoritiesString(evaledIfAnyGranted))).isEmpty()) {
            return 0;
        }
        return 1;
    }

    private Collection getPrincipalAuthorities() {
        SecureContext context = (SecureContext)ContextHolder.getContext();
        if (null == context) {
            return Collections.EMPTY_LIST;
        }
        Authentication currentUser = context.getAuthentication();
        if (null == currentUser) {
            return Collections.EMPTY_LIST;
        }
        List<GrantedAuthority> granted = Arrays.asList(currentUser.getAuthorities());
        return granted;
    }

    private Set parseAuthoritiesString(String authorizationsString) {
        HashSet<GrantedAuthorityImpl> requiredAuthorities = new HashSet<GrantedAuthorityImpl>();
        StringTokenizer tokenizer = new StringTokenizer(authorizationsString, ",", false);
        while (tokenizer.hasMoreTokens()) {
            String role = tokenizer.nextToken();
            requiredAuthorities.add(new GrantedAuthorityImpl(role.trim()));
        }
        return requiredAuthorities;
    }

    private Set retainAll(Collection granted, Set requiredAuthorities) {
        HashSet grantedCopy = new HashSet(granted);
        grantedCopy.retainAll(requiredAuthorities);
        return grantedCopy;
    }
}

