/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.acl.basic;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.acegisecurity.acl.basic.AclObjectIdentity;

public class NamedEntityObjectIdentity
implements AclObjectIdentity {
    private String classname;
    private String id;

    public NamedEntityObjectIdentity(String classname, String id) {
        if (classname == null || "".equals(classname)) {
            throw new IllegalArgumentException("classname required");
        }
        if (id == null || "".equals(id)) {
            throw new IllegalArgumentException("id required");
        }
        this.classname = classname;
        this.id = id;
    }

    public NamedEntityObjectIdentity(Object object) throws IllegalAccessException, InvocationTargetException {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null");
        }
        this.classname = object.getClass().getName();
        Class<?> clazz = object.getClass();
        try {
            Method method = clazz.getMethod("getId", null);
            Object result = method.invoke(object, null);
            this.id = result.toString();
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("Object of class '" + clazz + "' does not provide the required getId() method: " + object);
        }
    }

    protected NamedEntityObjectIdentity() {
        throw new IllegalArgumentException("Cannot use default constructor");
    }

    public String getClassname() {
        return this.classname;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (!(arg0 instanceof NamedEntityObjectIdentity)) {
            return false;
        }
        NamedEntityObjectIdentity other = (NamedEntityObjectIdentity)arg0;
        return this.getId().equals(other.getId()) && this.getClassname().equals(other.getClassname());
    }

    public int hashCode() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.classname).append(this.id);
        return sb.toString().hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append("[");
        sb.append("Classname: ").append(this.classname);
        sb.append("; Identity: ").append(this.id).append("]");
        return sb.toString();
    }
}

