/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.afterinvocation;

import java.util.Collection;
import java.util.Iterator;
import net.sf.acegisecurity.AccessDeniedException;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthorizationServiceException;
import net.sf.acegisecurity.ConfigAttribute;
import net.sf.acegisecurity.ConfigAttributeDefinition;
import net.sf.acegisecurity.acl.AclEntry;
import net.sf.acegisecurity.acl.AclManager;
import net.sf.acegisecurity.acl.basic.AbstractBasicAclEntry;
import net.sf.acegisecurity.acl.basic.SimpleAclEntry;
import net.sf.acegisecurity.afterinvocation.AfterInvocationProvider;
import net.sf.acegisecurity.afterinvocation.ArrayFilterer;
import net.sf.acegisecurity.afterinvocation.CollectionFilterer;
import net.sf.acegisecurity.afterinvocation.Filterer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class BasicAclEntryAfterInvocationCollectionFilteringProvider
implements AfterInvocationProvider,
InitializingBean {
    protected static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$afterinvocation$BasicAclEntryAfterInvocationCollectionFilteringProvider == null ? (class$net$sf$acegisecurity$afterinvocation$BasicAclEntryAfterInvocationCollectionFilteringProvider = BasicAclEntryAfterInvocationCollectionFilteringProvider.class$("net.sf.acegisecurity.afterinvocation.BasicAclEntryAfterInvocationCollectionFilteringProvider")) : class$net$sf$acegisecurity$afterinvocation$BasicAclEntryAfterInvocationCollectionFilteringProvider));
    private AclManager aclManager;
    private String processConfigAttribute = "AFTER_ACL_COLLECTION_READ";
    private int[] requirePermission = new int[]{SimpleAclEntry.READ};
    static /* synthetic */ Class class$net$sf$acegisecurity$afterinvocation$BasicAclEntryAfterInvocationCollectionFilteringProvider;

    public void setAclManager(AclManager aclManager) {
        this.aclManager = aclManager;
    }

    public AclManager getAclManager() {
        return this.aclManager;
    }

    public void setProcessConfigAttribute(String processConfigAttribute) {
        this.processConfigAttribute = processConfigAttribute;
    }

    public String getProcessConfigAttribute() {
        return this.processConfigAttribute;
    }

    public void setRequirePermission(int[] requirePermission) {
        this.requirePermission = requirePermission;
    }

    public int[] getRequirePermission() {
        return this.requirePermission;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.processConfigAttribute == null) {
            throw new IllegalArgumentException("A processConfigAttribute is mandatory");
        }
        if (this.requirePermission == null || this.requirePermission.length == 0) {
            throw new IllegalArgumentException("One or more requirePermission entries is mandatory");
        }
        if (this.aclManager == null) {
            throw new IllegalArgumentException("An aclManager is mandatory");
        }
    }

    public Object decide(Authentication authentication, Object object, ConfigAttributeDefinition config, Object returnedObject) throws AccessDeniedException {
        Iterator iter = config.getConfigAttributes();
        while (iter.hasNext()) {
            ConfigAttribute attr = (ConfigAttribute)iter.next();
            if (!this.supports(attr)) continue;
            if (returnedObject == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Return object is null, skipping");
                }
                return null;
            }
            Filterer filterer = null;
            if (returnedObject instanceof Collection) {
                Collection collection = (Collection)returnedObject;
                filterer = new CollectionFilterer(collection);
            } else if (returnedObject.getClass().isArray()) {
                Object[] array = (Object[])returnedObject;
                filterer = new ArrayFilterer(array);
            } else {
                throw new AuthorizationServiceException("A Collection or an array (or null) was required as the returnedObject, but the returnedObject was: " + returnedObject);
            }
            Iterator collectionIter = filterer.iterator();
            while (collectionIter.hasNext()) {
                Object domainObject = collectionIter.next();
                boolean hasPermission = false;
                AclEntry[] acls = null;
                if (domainObject == null) {
                    hasPermission = true;
                } else {
                    acls = this.aclManager.getAcls(domainObject, authentication);
                }
                if (acls != null && acls.length != 0) {
                    for (int i = 0; i < acls.length; ++i) {
                        if (!(acls[i] instanceof AbstractBasicAclEntry)) continue;
                        AbstractBasicAclEntry processableAcl = (AbstractBasicAclEntry)acls[i];
                        for (int y = 0; y < this.requirePermission.length; ++y) {
                            if (!processableAcl.isPermitted(this.requirePermission[y])) continue;
                            hasPermission = true;
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("Principal is authorised for element: " + domainObject + " due to ACL: " + processableAcl.toString()));
                        }
                    }
                }
                if (hasPermission) continue;
                filterer.remove(domainObject);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Principal is NOT authorised for element: " + domainObject));
            }
            return filterer.getFilteredObject();
        }
        return returnedObject;
    }

    public boolean supports(ConfigAttribute attribute) {
        return attribute.getAttribute() != null && attribute.getAttribute().equals(this.getProcessConfigAttribute());
    }

    public boolean supports(Class clazz) {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

