/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.providers.anonymous;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.context.security.SecureContext;
import net.sf.acegisecurity.context.security.SecureContextUtils;
import net.sf.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import net.sf.acegisecurity.providers.dao.memory.UserAttribute;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class AnonymousProcessingFilter
implements Filter,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$providers$anonymous$AnonymousProcessingFilter == null ? (class$net$sf$acegisecurity$providers$anonymous$AnonymousProcessingFilter = AnonymousProcessingFilter.class$("net.sf.acegisecurity.providers.anonymous.AnonymousProcessingFilter")) : class$net$sf$acegisecurity$providers$anonymous$AnonymousProcessingFilter));
    private String key;
    private UserAttribute userAttribute;
    static /* synthetic */ Class class$net$sf$acegisecurity$providers$anonymous$AnonymousProcessingFilter;

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setUserAttribute(UserAttribute userAttributeDefinition) {
        this.userAttribute = userAttributeDefinition;
    }

    public UserAttribute getUserAttribute() {
        return this.userAttribute;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.userAttribute);
        Assert.hasLength((String)this.key);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SecureContext sc = SecureContextUtils.getSecureContext();
        if (sc.getAuthentication() == null) {
            sc.setAuthentication(this.createAuthentication(request));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Replaced ContextHolder with anonymous token: '" + sc.getAuthentication() + "'"));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("ContextHolder not replaced with anonymous token, as ContextHolder already contained: '" + sc.getAuthentication() + "'"));
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    protected Authentication createAuthentication(ServletRequest request) {
        return new AnonymousAuthenticationToken(this.key, this.userAttribute.getPassword(), this.userAttribute.getAuthorities());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

