/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.providers.rcp;

import net.sf.acegisecurity.AuthenticationException;
import net.sf.acegisecurity.AuthenticationManager;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import net.sf.acegisecurity.providers.rcp.RemoteAuthenticationException;
import net.sf.acegisecurity.providers.rcp.RemoteAuthenticationManager;
import org.springframework.beans.factory.InitializingBean;

public class RemoteAuthenticationManagerImpl
implements RemoteAuthenticationManager,
InitializingBean {
    private AuthenticationManager authenticationManager;

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.authenticationManager == null) {
            throw new IllegalArgumentException("authenticationManager is required");
        }
    }

    public GrantedAuthority[] attemptAuthentication(String username, String password) throws RemoteAuthenticationException {
        UsernamePasswordAuthenticationToken request = new UsernamePasswordAuthenticationToken(username, password);
        try {
            return this.authenticationManager.authenticate(request).getAuthorities();
        }
        catch (AuthenticationException authEx) {
            throw new RemoteAuthenticationException(authEx.getMessage());
        }
    }
}

