/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.util;

import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class StringSplitUtils {
    public static String[] split(String toSplit, String delimiter) {
        Assert.hasLength((String)toSplit, (String)"Cannot split a null or empty string");
        Assert.hasLength((String)delimiter, (String)"Cannot use a null or empty delimiter to split a string");
        if (delimiter.length() != 1) {
            throw new IllegalArgumentException("Delimiter can only be one character in length");
        }
        int offset = toSplit.indexOf(61);
        if (offset < 0) {
            return null;
        }
        String beforeDelimiter = toSplit.substring(0, offset);
        String afterDelimiter = toSplit.substring(offset + 1);
        return new String[]{beforeDelimiter, afterDelimiter};
    }

    public static Map splitEachArrayElementAndCreateMap(String[] array, String delimiter, String removeCharacters) {
        if (array == null || array.length == 0) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < array.length; ++i) {
            String postRemove = removeCharacters == null ? array[i] : StringUtils.replace((String)array[i], (String)removeCharacters, (String)"");
            String[] splitThisArrayElement = StringSplitUtils.split(postRemove, delimiter);
            if (splitThisArrayElement == null) continue;
            map.put(splitThisArrayElement[0].trim(), splitThisArrayElement[1].trim());
        }
        return map;
    }
}

