/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.providers.dao;

import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.UserDetails;

public class User
implements UserDetails {
    private String password;
    private String username;
    private GrantedAuthority[] authorities;
    private boolean accountNonExpired;
    private boolean accountNonLocked;
    private boolean credentialsNonExpired;
    private boolean enabled;

    public User(String username, String password, boolean enabled, GrantedAuthority[] authorities) throws IllegalArgumentException {
        this(username, password, enabled, true, true, authorities);
    }

    public User(String username, String password, boolean enabled, boolean accountNonExpired, boolean credentialsNonExpired, GrantedAuthority[] authorities) throws IllegalArgumentException {
        this(username, password, enabled, accountNonExpired, credentialsNonExpired, true, authorities);
    }

    public User(String username, String password, boolean enabled, boolean accountNonExpired, boolean credentialsNonExpired, boolean accountNonLocked, GrantedAuthority[] authorities) throws IllegalArgumentException {
        if (username == null || "".equals(username) || password == null || authorities == null) {
            throw new IllegalArgumentException("Cannot pass null or empty values to constructor");
        }
        for (int i = 0; i < authorities.length; ++i) {
            if (authorities[i] != null) continue;
            throw new IllegalArgumentException("Granted authority element " + i + " is null - GrantedAuthority[] cannot contain any null elements");
        }
        this.username = username;
        this.password = password;
        this.enabled = enabled;
        this.authorities = authorities;
        this.accountNonExpired = accountNonExpired;
        this.credentialsNonExpired = credentialsNonExpired;
        this.accountNonLocked = accountNonLocked;
    }

    protected User() {
        throw new IllegalArgumentException("Cannot use default constructor");
    }

    public boolean isAccountNonExpired() {
        return this.accountNonExpired;
    }

    public boolean isAccountNonLocked() {
        return this.accountNonLocked;
    }

    public GrantedAuthority[] getAuthorities() {
        return this.authorities;
    }

    public boolean isCredentialsNonExpired() {
        return this.credentialsNonExpired;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString() + ": ");
        sb.append("Username: " + this.username + "; ");
        sb.append("Password: [PROTECTED]; ");
        sb.append("Enabled: " + this.enabled + "; ");
        sb.append("AccountNonExpired: " + this.accountNonExpired + "; ");
        sb.append("credentialsNonExpired: " + this.credentialsNonExpired + "; ");
        sb.append("AccountNonLocked: " + this.accountNonLocked + "; ");
        if (this.getAuthorities() != null) {
            sb.append("Granted Authorities: ");
            for (int i = 0; i < this.getAuthorities().length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.getAuthorities()[i].toString());
            }
        } else {
            sb.append("Not granted any authorities");
        }
        return sb.toString();
    }
}

