/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.providers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationTrustResolver;
import net.sf.acegisecurity.AuthenticationTrustResolverImpl;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.providers.ConcurrentLoginException;
import net.sf.acegisecurity.providers.ConcurrentSessionController;
import net.sf.acegisecurity.ui.WebAuthenticationDetails;
import net.sf.acegisecurity.ui.session.HttpSessionDestroyedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class ConcurrentSessionControllerImpl
implements ConcurrentSessionController,
ApplicationListener {
    protected Map principalsToSessions = new HashMap();
    protected Map sessionsToPrincipals = new HashMap();
    protected Set sessionSet = new HashSet();
    private AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();
    private int maxSessions = 1;

    public void setMaxSessions(int maxSessions) {
        this.maxSessions = maxSessions;
    }

    public int getMaxSessions() {
        return this.maxSessions;
    }

    public void setTrustResolver(AuthenticationTrustResolver trustResolver) {
        this.trustResolver = trustResolver;
    }

    public AuthenticationTrustResolver getTrustResolver() {
        return this.trustResolver;
    }

    public void afterAuthentication(Authentication request, Authentication response) {
        this.enforceConcurrentLogins(response);
        if (request.getDetails() instanceof WebAuthenticationDetails) {
            String sessionId = ((WebAuthenticationDetails)request.getDetails()).getSessionId();
            this.addSession(this.determineSessionPrincipal(response), sessionId);
        }
    }

    public void beforeAuthentication(Authentication request) throws ConcurrentLoginException {
        this.enforceConcurrentLogins(request);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof HttpSessionDestroyedEvent) {
            String sessionId = ((HttpSession)event.getSource()).getId();
            this.removeSession(sessionId);
        }
    }

    protected boolean isActiveSession(Object principal, String sessionId) {
        Set sessions = (Set)this.principalsToSessions.get(principal);
        if (sessions == null) {
            return false;
        }
        return sessions.contains(sessionId);
    }

    protected void addSession(Object principal, String sessionId) {
        HashSet<String> sessions = (HashSet<String>)this.principalsToSessions.get(principal);
        if (sessions == null) {
            sessions = new HashSet<String>();
            this.principalsToSessions.put(principal, sessions);
        }
        sessions.add(sessionId);
        this.sessionsToPrincipals.put(sessionId, principal);
    }

    protected int countSessions(Object principal) {
        Set set = (Set)this.principalsToSessions.get(principal);
        if (set == null) {
            return 0;
        }
        return set.size();
    }

    protected Object determineSessionPrincipal(Authentication auth) {
        if (auth.getPrincipal() instanceof UserDetails) {
            return ((UserDetails)auth.getPrincipal()).getUsername();
        }
        return auth.getPrincipal().toString();
    }

    protected void enforceConcurrentLogins(Authentication request) throws ConcurrentLoginException {
        if (this.maxSessions < 1) {
            return;
        }
        if (this.trustResolver.isAnonymous(request)) {
            return;
        }
        if (request.getDetails() instanceof WebAuthenticationDetails) {
            String sessionId = ((WebAuthenticationDetails)request.getDetails()).getSessionId();
            Object principal = this.determineSessionPrincipal(request);
            if (!this.isActiveSession(principal, sessionId) && this.maxSessions == this.countSessions(principal)) {
                throw new ConcurrentLoginException(principal + " has reached the maximum concurrent logins");
            }
        }
    }

    protected void removeSession(String sessionId) {
        Object associatedPrincipal = this.sessionsToPrincipals.get(sessionId);
        if (associatedPrincipal != null) {
            Set sessions = (Set)this.principalsToSessions.get(associatedPrincipal);
            sessions.remove(sessionId);
            if (sessions.isEmpty()) {
                this.principalsToSessions.remove(associatedPrincipal);
            }
            this.sessionsToPrincipals.remove(sessionId);
        }
    }
}

