/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.providers.dao;

import net.sf.acegisecurity.AccountExpiredException;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationException;
import net.sf.acegisecurity.AuthenticationServiceException;
import net.sf.acegisecurity.BadCredentialsException;
import net.sf.acegisecurity.CredentialsExpiredException;
import net.sf.acegisecurity.DisabledException;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.LockedException;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.providers.AuthenticationProvider;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import net.sf.acegisecurity.providers.dao.AuthenticationDao;
import net.sf.acegisecurity.providers.dao.SaltSource;
import net.sf.acegisecurity.providers.dao.User;
import net.sf.acegisecurity.providers.dao.UserCache;
import net.sf.acegisecurity.providers.dao.UsernameNotFoundException;
import net.sf.acegisecurity.providers.dao.cache.NullUserCache;
import net.sf.acegisecurity.providers.dao.event.AuthenticationFailureAccountExpiredEvent;
import net.sf.acegisecurity.providers.dao.event.AuthenticationFailureAccountLockedEvent;
import net.sf.acegisecurity.providers.dao.event.AuthenticationFailureCredentialsExpiredEvent;
import net.sf.acegisecurity.providers.dao.event.AuthenticationFailureDisabledEvent;
import net.sf.acegisecurity.providers.dao.event.AuthenticationFailurePasswordEvent;
import net.sf.acegisecurity.providers.dao.event.AuthenticationFailureUsernameNotFoundEvent;
import net.sf.acegisecurity.providers.dao.event.AuthenticationSuccessEvent;
import net.sf.acegisecurity.providers.encoding.PasswordEncoder;
import net.sf.acegisecurity.providers.encoding.PlaintextPasswordEncoder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.dao.DataAccessException;

public class DaoAuthenticationProvider
implements AuthenticationProvider,
InitializingBean,
ApplicationContextAware {
    private ApplicationContext context;
    private AuthenticationDao authenticationDao;
    private PasswordEncoder passwordEncoder = new PlaintextPasswordEncoder();
    private SaltSource saltSource;
    private UserCache userCache = new NullUserCache();
    private boolean forcePrincipalAsString = false;
    private boolean hideUserNotFoundExceptions = true;
    static /* synthetic */ Class class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public void setAuthenticationDao(AuthenticationDao authenticationDao) {
        this.authenticationDao = authenticationDao;
    }

    public AuthenticationDao getAuthenticationDao() {
        return this.authenticationDao;
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    public void setForcePrincipalAsString(boolean forcePrincipalAsString) {
        this.forcePrincipalAsString = forcePrincipalAsString;
    }

    public boolean isForcePrincipalAsString() {
        return this.forcePrincipalAsString;
    }

    public void setHideUserNotFoundExceptions(boolean hideUserNotFoundExceptions) {
        this.hideUserNotFoundExceptions = hideUserNotFoundExceptions;
    }

    public boolean isHideUserNotFoundExceptions() {
        return this.hideUserNotFoundExceptions;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public void setSaltSource(SaltSource saltSource) {
        this.saltSource = saltSource;
    }

    public SaltSource getSaltSource() {
        return this.saltSource;
    }

    public void setUserCache(UserCache userCache) {
        this.userCache = userCache;
    }

    public UserCache getUserCache() {
        return this.userCache;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.authenticationDao == null) {
            throw new IllegalArgumentException("An Authentication DAO must be set");
        }
        if (this.userCache == null) {
            throw new IllegalArgumentException("A user cache must be set");
        }
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String username = "NONE_PROVIDED";
        if (authentication.getPrincipal() != null) {
            username = authentication.getPrincipal().toString();
        }
        if (authentication.getPrincipal() instanceof UserDetails) {
            username = ((UserDetails)authentication.getPrincipal()).getUsername();
        }
        boolean cacheWasUsed = true;
        UserDetails user = this.userCache.getUserFromCache(username);
        if (user == null) {
            cacheWasUsed = false;
            try {
                user = this.getUserFromBackend(username);
            }
            catch (BadCredentialsException ex) {
                if (this.context != null) {
                    this.context.publishEvent((ApplicationEvent)new AuthenticationFailureUsernameNotFoundEvent(authentication, new User("".equals(username) ? "EMPTY_STRING_PROVIDED" : username, "*****", false, false, false, false, new GrantedAuthority[0])));
                }
                throw ex;
            }
        }
        if (!user.isEnabled()) {
            if (this.context != null) {
                this.context.publishEvent((ApplicationEvent)new AuthenticationFailureDisabledEvent(authentication, user));
            }
            throw new DisabledException("User is disabled");
        }
        if (!user.isAccountNonExpired()) {
            if (this.context != null) {
                this.context.publishEvent((ApplicationEvent)new AuthenticationFailureAccountExpiredEvent(authentication, user));
            }
            throw new AccountExpiredException("User account has expired");
        }
        if (!user.isAccountNonLocked()) {
            if (this.context != null) {
                this.context.publishEvent((ApplicationEvent)new AuthenticationFailureAccountLockedEvent(authentication, user));
            }
            throw new LockedException("User account is locked");
        }
        if (!user.isCredentialsNonExpired()) {
            if (this.context != null) {
                this.context.publishEvent((ApplicationEvent)new AuthenticationFailureCredentialsExpiredEvent(authentication, user));
            }
            throw new CredentialsExpiredException("User credentials have expired");
        }
        if (!this.isPasswordCorrect(authentication, user)) {
            if (cacheWasUsed) {
                cacheWasUsed = false;
                user = this.getUserFromBackend(username);
            }
            if (!this.isPasswordCorrect(authentication, user)) {
                if (this.context != null) {
                    this.context.publishEvent((ApplicationEvent)new AuthenticationFailurePasswordEvent(authentication, user));
                }
                throw new BadCredentialsException("Bad credentials presented");
            }
        }
        if (!cacheWasUsed) {
            this.userCache.putUserInCache(user);
            if (this.context != null) {
                this.context.publishEvent((ApplicationEvent)new AuthenticationSuccessEvent(authentication, user));
            }
        }
        Object principalToReturn = user;
        if (this.forcePrincipalAsString) {
            principalToReturn = user.getUsername();
        }
        return this.createSuccessAuthentication(principalToReturn, authentication, user);
    }

    public boolean supports(Class authentication) {
        return (class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken == null ? (class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken = DaoAuthenticationProvider.class$("net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken")) : class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken).isAssignableFrom(authentication);
    }

    protected boolean isPasswordCorrect(Authentication authentication, UserDetails user) {
        Object salt = null;
        if (this.saltSource != null) {
            salt = this.saltSource.getSalt(user);
        }
        return this.passwordEncoder.isPasswordValid(user.getPassword(), authentication.getCredentials().toString(), salt);
    }

    protected Authentication createSuccessAuthentication(Object principal, Authentication authentication, UserDetails user) {
        UsernamePasswordAuthenticationToken result = new UsernamePasswordAuthenticationToken(principal, authentication.getCredentials(), user.getAuthorities());
        result.setDetails(authentication.getDetails() != null ? authentication.getDetails() : null);
        return result;
    }

    private UserDetails getUserFromBackend(String username) {
        UserDetails loadedUser;
        try {
            loadedUser = this.authenticationDao.loadUserByUsername(username);
        }
        catch (UsernameNotFoundException notFound) {
            if (this.hideUserNotFoundExceptions) {
                throw new BadCredentialsException("Bad credentials presented");
            }
            throw notFound;
        }
        catch (DataAccessException repositoryProblem) {
            throw new AuthenticationServiceException(repositoryProblem.getMessage(), repositoryProblem);
        }
        if (loadedUser == null) {
            throw new AuthenticationServiceException("AuthenticationDao returned null, which is an interface contract violation");
        }
        return loadedUser;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

