/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.context;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sf.acegisecurity.context.Context;
import net.sf.acegisecurity.context.ContextHolder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class HttpSessionContextIntegrationFilter
implements InitializingBean,
Filter {
    protected static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$context$HttpSessionContextIntegrationFilter == null ? (class$net$sf$acegisecurity$context$HttpSessionContextIntegrationFilter = HttpSessionContextIntegrationFilter.class$("net.sf.acegisecurity.context.HttpSessionContextIntegrationFilter")) : class$net$sf$acegisecurity$context$HttpSessionContextIntegrationFilter));
    private static final String FILTER_APPLIED = "__acegi_session_integration_filter_applied";
    public static final String ACEGI_SECURITY_CONTEXT_KEY = "ACEGI_SECURITY_CONTEXT";
    private Class context;
    private Object contextObject;
    private boolean allowSessionCreation = true;
    static /* synthetic */ Class class$net$sf$acegisecurity$context$HttpSessionContextIntegrationFilter;
    static /* synthetic */ Class class$net$sf$acegisecurity$context$Context;

    public void setAllowSessionCreation(boolean allowSessionCreation) {
        this.allowSessionCreation = allowSessionCreation;
    }

    public boolean isAllowSessionCreation() {
        return this.allowSessionCreation;
    }

    public void setContext(Class secureContext) {
        this.context = secureContext;
    }

    public Class getContext() {
        return this.context;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.context == null || !(class$net$sf$acegisecurity$context$Context == null ? (class$net$sf$acegisecurity$context$Context = HttpSessionContextIntegrationFilter.class$("net.sf.acegisecurity.context.Context")) : class$net$sf$acegisecurity$context$Context).isAssignableFrom(this.context)) {
            throw new IllegalArgumentException("context must be defined and implement Context (typically use net.sf.acegisecurity.context.security.SecureContextImpl)");
        }
        this.contextObject = this.generateNewContext();
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request != null && request.getAttribute(FILTER_APPLIED) != null) {
            chain.doFilter(request, response);
        } else {
            if (request != null) {
                request.setAttribute(FILTER_APPLIED, (Object)Boolean.TRUE);
            }
            if (ContextHolder.getContext() != null) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("ContextHolder should have been null but contained: '" + ContextHolder.getContext() + "'; setting to null now"));
                }
                ContextHolder.setContext(null);
            }
            HttpSession httpSession = null;
            boolean httpSessionExistedAtStartOfRequest = false;
            try {
                httpSession = ((HttpServletRequest)request).getSession(false);
            }
            catch (IllegalStateException ignored) {
                // empty catch block
            }
            if (httpSession != null) {
                httpSessionExistedAtStartOfRequest = true;
                Object contextObject = httpSession.getAttribute(ACEGI_SECURITY_CONTEXT_KEY);
                if (contextObject != null) {
                    if (contextObject instanceof Context) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Obtained from ACEGI_SECURITY_CONTEXT a valid Context and set to ContextHolder: '" + contextObject + "'"));
                        }
                        ContextHolder.setContext((Context)contextObject);
                    } else if (logger.isWarnEnabled()) {
                        logger.warn((Object)("ACEGI_SECURITY_CONTEXT did not contain a Context but contained: '" + contextObject + "'; are you improperly modifying the HttpSession directly (you should always use ContextHolder) or using the HttpSession attribute reserved for this class?"));
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)"HttpSession returned null object for ACEGI_SECURITY_CONTEXT");
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)"No HttpSession currently exists");
            }
            if (ContextHolder.getContext() == null) {
                ContextHolder.setContext(this.generateNewContext());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("As ContextHolder null, setup ContextHolder with a fresh new instance: '" + ContextHolder.getContext() + "'"));
                }
            }
            httpSession = null;
            chain.doFilter(request, response);
            try {
                httpSession = ((HttpServletRequest)request).getSession(false);
            }
            catch (IllegalStateException ignored) {
                // empty catch block
            }
            if (httpSession == null && httpSessionExistedAtStartOfRequest && logger.isDebugEnabled()) {
                logger.debug((Object)"HttpSession is now null, but was not null at start of request; session was invalidated, so do not create a new session");
            }
            if (httpSession == null && !httpSessionExistedAtStartOfRequest) {
                if (!this.allowSessionCreation) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Whilst ContextHolder contents have changed, the HttpSessionContextIntegrationFilter is prohibited from creating a HttpSession by the allowSessionCreation property being false");
                    }
                } else if (!this.contextObject.equals(ContextHolder.getContext())) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"HttpSession being created as ContextHolder contents are non-default");
                    }
                    try {
                        httpSession = ((HttpServletRequest)request).getSession(true);
                    }
                    catch (IllegalStateException ignored) {}
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("HttpSession still null, but ContextHolder has not changed from default: ' " + ContextHolder.getContext() + "'; not creating HttpSession or storing ContextHolder contents"));
                }
            }
            if (httpSession != null) {
                httpSession.setAttribute(ACEGI_SECURITY_CONTEXT_KEY, (Object)ContextHolder.getContext());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Context stored to HttpSession: '" + ContextHolder.getContext() + "'"));
                }
            }
            ContextHolder.setContext(null);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"ContextHolder set to null as request processing completed");
            }
        }
    }

    public Context generateNewContext() throws ServletException {
        try {
            return (Context)this.context.newInstance();
        }
        catch (InstantiationException ie) {
            throw new ServletException((Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            throw new ServletException((Throwable)iae);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

