/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.afterinvocation;

import java.util.Iterator;
import net.sf.acegisecurity.AccessDeniedException;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.ConfigAttribute;
import net.sf.acegisecurity.ConfigAttributeDefinition;
import net.sf.acegisecurity.acl.AclEntry;
import net.sf.acegisecurity.acl.AclManager;
import net.sf.acegisecurity.acl.basic.BasicAclEntry;
import net.sf.acegisecurity.acl.basic.SimpleAclEntry;
import net.sf.acegisecurity.afterinvocation.AfterInvocationProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class BasicAclEntryAfterInvocationProvider
implements AfterInvocationProvider,
InitializingBean {
    protected static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$afterinvocation$BasicAclEntryAfterInvocationProvider == null ? (class$net$sf$acegisecurity$afterinvocation$BasicAclEntryAfterInvocationProvider = BasicAclEntryAfterInvocationProvider.class$("net.sf.acegisecurity.afterinvocation.BasicAclEntryAfterInvocationProvider")) : class$net$sf$acegisecurity$afterinvocation$BasicAclEntryAfterInvocationProvider));
    private AclManager aclManager;
    private String processConfigAttribute = "AFTER_ACL_READ";
    private int[] requirePermission = new int[]{SimpleAclEntry.READ};
    static /* synthetic */ Class class$net$sf$acegisecurity$afterinvocation$BasicAclEntryAfterInvocationProvider;

    public void setAclManager(AclManager aclManager) {
        this.aclManager = aclManager;
    }

    public AclManager getAclManager() {
        return this.aclManager;
    }

    public void setProcessConfigAttribute(String processConfigAttribute) {
        this.processConfigAttribute = processConfigAttribute;
    }

    public String getProcessConfigAttribute() {
        return this.processConfigAttribute;
    }

    public void setRequirePermission(int[] requirePermission) {
        this.requirePermission = requirePermission;
    }

    public int[] getRequirePermission() {
        return this.requirePermission;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.processConfigAttribute, (String)"A processConfigAttribute is mandatory");
        Assert.notNull((Object)this.aclManager, (String)"An aclManager is mandatory");
        if (this.requirePermission == null || this.requirePermission.length == 0) {
            throw new IllegalArgumentException("One or more requirePermission entries is mandatory");
        }
    }

    public Object decide(Authentication authentication, Object object, ConfigAttributeDefinition config, Object returnedObject) throws AccessDeniedException {
        Iterator iter = config.getConfigAttributes();
        while (iter.hasNext()) {
            ConfigAttribute attr = (ConfigAttribute)iter.next();
            if (!this.supports(attr)) continue;
            if (returnedObject == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Return object is null, skipping");
                }
                return null;
            }
            AclEntry[] acls = this.aclManager.getAcls(returnedObject, authentication);
            if (acls == null || acls.length == 0) {
                throw new AccessDeniedException("Authentication: " + authentication.toString() + " has NO permissions at all to the domain object: " + returnedObject);
            }
            for (int i = 0; i < acls.length; ++i) {
                if (!(acls[i] instanceof BasicAclEntry)) continue;
                BasicAclEntry processableAcl = (BasicAclEntry)acls[i];
                for (int y = 0; y < this.requirePermission.length; ++y) {
                    if (!processableAcl.isPermitted(this.requirePermission[y])) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Principal DOES have permission to return object: " + returnedObject + " due to ACL: " + processableAcl.toString()));
                    }
                    return returnedObject;
                }
            }
            throw new AccessDeniedException("Authentication: " + authentication.toString() + " has ACL permissions to the domain object, but not the required ACL permission to the domain object: " + returnedObject);
        }
        return returnedObject;
    }

    public boolean supports(ConfigAttribute attribute) {
        return attribute.getAttribute() != null && attribute.getAttribute().equals(this.getProcessConfigAttribute());
    }

    public boolean supports(Class clazz) {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

