/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.captcha;

import java.io.IOException;
import java.util.Iterator;
import javax.servlet.ServletException;
import net.sf.acegisecurity.ConfigAttribute;
import net.sf.acegisecurity.ConfigAttributeDefinition;
import net.sf.acegisecurity.captcha.CaptchaSecurityContext;
import net.sf.acegisecurity.context.SecurityContextHolder;
import net.sf.acegisecurity.intercept.web.FilterInvocation;
import net.sf.acegisecurity.securechannel.ChannelEntryPoint;
import net.sf.acegisecurity.securechannel.ChannelProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public abstract class CaptchaChannelProcessorTemplate
implements ChannelProcessor,
InitializingBean {
    protected Log logger = LogFactory.getLog(this.getClass());
    private ChannelEntryPoint entryPoint;
    private String keyword = null;
    private int thresold = 0;

    public void setEntryPoint(ChannelEntryPoint entryPoint) {
        this.entryPoint = entryPoint;
    }

    public ChannelEntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setThresold(int thresold) {
        this.thresold = thresold;
    }

    public int getThresold() {
        return this.thresold;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.entryPoint, (String)"entryPoint required");
        Assert.hasLength((String)this.keyword, (String)"keyword required");
    }

    public void decide(FilterInvocation invocation, ConfigAttributeDefinition config) throws IOException, ServletException {
        if (invocation == null || config == null) {
            throw new IllegalArgumentException("Nulls cannot be provided");
        }
        CaptchaSecurityContext context = null;
        context = (CaptchaSecurityContext)SecurityContextHolder.getContext();
        Iterator iter = config.getConfigAttributes();
        while (iter.hasNext()) {
            ConfigAttribute attribute = (ConfigAttribute)iter.next();
            if (this.supports(attribute)) {
                this.logger.debug((Object)("supports this attribute : " + attribute));
                if (!this.isContextValidConcerningHumanity(context)) {
                    this.logger.debug((Object)"context is not allowed to access ressource, redirect to captcha entry point");
                    this.redirectToEntryPoint(invocation);
                    continue;
                }
                this.logger.debug((Object)"has been successfully checked this keyword, increment request count");
                context.incrementHumanRestrictedRessoucesRequestsCount();
                continue;
            }
            this.logger.debug((Object)"do not support this attribute");
        }
    }

    public boolean supports(ConfigAttribute attribute) {
        return attribute != null && this.keyword.equals(attribute.getAttribute());
    }

    abstract boolean isContextValidConcerningHumanity(CaptchaSecurityContext var1);

    private void redirectToEntryPoint(FilterInvocation invocation) throws IOException, ServletException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"context is not valid : redirecting to entry point");
        }
        this.entryPoint.commence(invocation.getRequest(), invocation.getResponse());
    }
}

