/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.concurrent;

import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationException;
import net.sf.acegisecurity.concurrent.ConcurrentLoginException;
import net.sf.acegisecurity.concurrent.ConcurrentSessionController;
import net.sf.acegisecurity.concurrent.SessionInformation;
import net.sf.acegisecurity.concurrent.SessionRegistry;
import net.sf.acegisecurity.concurrent.SessionRegistryImpl;
import net.sf.acegisecurity.concurrent.SessionRegistryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class ConcurrentSessionControllerImpl
implements ConcurrentSessionController,
InitializingBean {
    private SessionRegistry sessionRegistry = new SessionRegistryImpl();
    private int maximumSessions = 1;
    private boolean exceptionIfMaximumExceeded = false;

    public void setMaximumSessions(int maximumSessions) {
        this.maximumSessions = maximumSessions;
    }

    public void setSessionRegistry(SessionRegistry sessionRegistry) {
        this.sessionRegistry = sessionRegistry;
    }

    public void setExceptionIfMaximumExceeded(boolean exceptionIfMaximumExceeded) {
        this.exceptionIfMaximumExceeded = exceptionIfMaximumExceeded;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.sessionRegistry, (String)"SessionRegistry required");
        Assert.isTrue((this.maximumSessions != 0 ? 1 : 0) != 0, (String)"MaximumLogins must be either -1 to allow unlimited logins, or a positive integer to specify a maximum");
    }

    public void checkAuthenticationAllowed(Authentication request) throws AuthenticationException {
        int allowableSessions;
        Assert.notNull((Object)request, (String)"Authentication request cannot be null (violation of interface contract)");
        Object principal = SessionRegistryUtils.obtainPrincipalFromAuthentication(request);
        String sessionId = SessionRegistryUtils.obtainSessionIdFromAuthentication(request);
        SessionInformation[] sessions = this.sessionRegistry.getAllSessions(principal);
        int sessionCount = 0;
        if (sessions != null) {
            sessionCount = sessions.length;
        }
        Assert.isTrue(((allowableSessions = this.getMaximumSessionsForThisUser(request)) != 0 ? 1 : 0) != 0, (String)"getMaximumSessionsForThisUser() must return either -1 to allow unlimited logins, or a positive integer to specify a maximum");
        if (sessionCount < allowableSessions) {
            return;
        }
        if (sessionCount == allowableSessions) {
            for (int i = 0; i < sessionCount; ++i) {
                if (!sessions[i].getSessionId().equals(sessionId)) continue;
                return;
            }
        }
        this.allowableSessionsExceeded(sessionId, sessions, allowableSessions, this.sessionRegistry);
    }

    protected void allowableSessionsExceeded(String sessionId, SessionInformation[] sessions, int allowableSessions, SessionRegistry registry) {
        if (this.exceptionIfMaximumExceeded || sessions == null) {
            throw new ConcurrentLoginException("Maximum sessions of " + allowableSessions + " for this principal exceeded");
        }
        SessionInformation leastRecentlyUsed = null;
        for (int i = 0; i < sessions.length; ++i) {
            if (leastRecentlyUsed != null && !sessions[i].getLastRequest().before(leastRecentlyUsed.getLastRequest())) continue;
            leastRecentlyUsed = sessions[i];
        }
        leastRecentlyUsed.expireNow();
    }

    public void registerSuccessfulAuthentication(Authentication authentication) {
        Assert.notNull((Object)authentication, (String)"Authentication cannot be null (violation of interface contract)");
        Object principal = SessionRegistryUtils.obtainPrincipalFromAuthentication(authentication);
        String sessionId = SessionRegistryUtils.obtainSessionIdFromAuthentication(authentication);
        this.sessionRegistry.removeSessionInformation(sessionId);
        this.sessionRegistry.registerNewSession(sessionId, principal);
    }

    protected int getMaximumSessionsForThisUser(Authentication authentication) {
        return this.maximumSessions;
    }
}

