/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.concurrent;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.acegisecurity.concurrent.SessionInformation;
import net.sf.acegisecurity.concurrent.SessionRegistry;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class ConcurrentSessionFilter
implements Filter,
InitializingBean {
    private SessionRegistry sessionRegistry;
    private String expiredUrl;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletResponse;

    public void setExpiredUrl(String expiredUrl) {
        this.expiredUrl = expiredUrl;
    }

    public void setSessionRegistry(SessionRegistry sessionRegistry) {
        this.sessionRegistry = sessionRegistry;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.sessionRegistry, (String)"SessionRegistry required");
        Assert.hasText((String)this.expiredUrl, (String)"ExpiredUrl required");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SessionInformation info;
        Assert.isInstanceOf((Class)(class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = ConcurrentSessionFilter.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest), (Object)request, (String)"Can only process HttpServletRequest");
        Assert.isInstanceOf((Class)(class$javax$servlet$http$HttpServletResponse == null ? (class$javax$servlet$http$HttpServletResponse = ConcurrentSessionFilter.class$("javax.servlet.http.HttpServletResponse")) : class$javax$servlet$http$HttpServletResponse), (Object)response, (String)"Can only process HttpServletResponse");
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpSession session = httpRequest.getSession(false);
        if (session != null && (info = this.sessionRegistry.getSessionInformation(session.getId())) != null) {
            if (info.isExpired()) {
                session.invalidate();
                String targetUrl = httpRequest.getContextPath() + this.expiredUrl;
                httpResponse.sendRedirect(httpResponse.encodeRedirectURL(targetUrl));
                return;
            }
            info.refreshLastRequest();
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

