/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.intercept;

import java.util.HashSet;
import java.util.Iterator;
import net.sf.acegisecurity.AccessDecisionManager;
import net.sf.acegisecurity.AccessDeniedException;
import net.sf.acegisecurity.AfterInvocationManager;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationCredentialsNotFoundException;
import net.sf.acegisecurity.AuthenticationManager;
import net.sf.acegisecurity.ConfigAttribute;
import net.sf.acegisecurity.ConfigAttributeDefinition;
import net.sf.acegisecurity.RunAsManager;
import net.sf.acegisecurity.context.SecurityContextHolder;
import net.sf.acegisecurity.event.authorization.AuthenticationCredentialsNotFoundEvent;
import net.sf.acegisecurity.event.authorization.AuthorizationFailureEvent;
import net.sf.acegisecurity.event.authorization.AuthorizedEvent;
import net.sf.acegisecurity.event.authorization.PublicInvocationEvent;
import net.sf.acegisecurity.intercept.InterceptorStatusToken;
import net.sf.acegisecurity.intercept.ObjectDefinitionSource;
import net.sf.acegisecurity.runas.NullRunAsManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.util.Assert;

public abstract class AbstractSecurityInterceptor
implements InitializingBean,
ApplicationEventPublisherAware {
    protected static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$intercept$AbstractSecurityInterceptor == null ? (class$net$sf$acegisecurity$intercept$AbstractSecurityInterceptor = AbstractSecurityInterceptor.class$("net.sf.acegisecurity.intercept.AbstractSecurityInterceptor")) : class$net$sf$acegisecurity$intercept$AbstractSecurityInterceptor));
    private AccessDecisionManager accessDecisionManager;
    private AfterInvocationManager afterInvocationManager;
    private ApplicationEventPublisher eventPublisher;
    private AuthenticationManager authenticationManager;
    private RunAsManager runAsManager = new NullRunAsManager();
    private boolean alwaysReauthenticate = false;
    private boolean validateConfigAttributes = true;
    static /* synthetic */ Class class$net$sf$acegisecurity$intercept$AbstractSecurityInterceptor;

    public void setAfterInvocationManager(AfterInvocationManager afterInvocationManager) {
        this.afterInvocationManager = afterInvocationManager;
    }

    public AfterInvocationManager getAfterInvocationManager() {
        return this.afterInvocationManager;
    }

    public void setAlwaysReauthenticate(boolean alwaysReauthenticate) {
        this.alwaysReauthenticate = alwaysReauthenticate;
    }

    public boolean isAlwaysReauthenticate() {
        return this.alwaysReauthenticate;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public abstract Class getSecureObjectClass();

    public abstract ObjectDefinitionSource obtainObjectDefinitionSource();

    public void setAccessDecisionManager(AccessDecisionManager accessDecisionManager) {
        this.accessDecisionManager = accessDecisionManager;
    }

    public AccessDecisionManager getAccessDecisionManager() {
        return this.accessDecisionManager;
    }

    public void setAuthenticationManager(AuthenticationManager newManager) {
        this.authenticationManager = newManager;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setRunAsManager(RunAsManager runAsManager) {
        this.runAsManager = runAsManager;
    }

    public RunAsManager getRunAsManager() {
        return this.runAsManager;
    }

    public void setValidateConfigAttributes(boolean validateConfigAttributes) {
        this.validateConfigAttributes = validateConfigAttributes;
    }

    public boolean isValidateConfigAttributes() {
        return this.validateConfigAttributes;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.getSecureObjectClass(), (String)"Subclass must provide a non-null response to getSecureObjectClass()");
        Assert.notNull((Object)this.authenticationManager, (String)"An AuthenticationManager is required");
        Assert.notNull((Object)this.accessDecisionManager, (String)"An AccessDecisionManager is required");
        Assert.notNull((Object)this.runAsManager, (String)"A RunAsManager is required");
        Assert.notNull((Object)this.obtainObjectDefinitionSource(), (String)"An ObjectDefinitionSource is required");
        if (!this.obtainObjectDefinitionSource().supports(this.getSecureObjectClass())) {
            throw new IllegalArgumentException("ObjectDefinitionSource does not support secure object class: " + this.getSecureObjectClass());
        }
        if (!this.runAsManager.supports(this.getSecureObjectClass())) {
            throw new IllegalArgumentException("RunAsManager does not support secure object class: " + this.getSecureObjectClass());
        }
        if (!this.accessDecisionManager.supports(this.getSecureObjectClass())) {
            throw new IllegalArgumentException("AccessDecisionManager does not support secure object class: " + this.getSecureObjectClass());
        }
        if (this.afterInvocationManager != null && !this.afterInvocationManager.supports(this.getSecureObjectClass())) {
            throw new IllegalArgumentException("AfterInvocationManager does not support secure object class: " + this.getSecureObjectClass());
        }
        if (this.validateConfigAttributes) {
            Iterator iter = this.obtainObjectDefinitionSource().getConfigAttributeDefinitions();
            if (iter == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)"Could not validate configuration attributes as the MethodDefinitionSource did not return a ConfigAttributeDefinition Iterator");
                }
            } else {
                HashSet<ConfigAttribute> set = new HashSet<ConfigAttribute>();
                while (iter.hasNext()) {
                    ConfigAttributeDefinition def = (ConfigAttributeDefinition)iter.next();
                    Iterator attributes = def.getConfigAttributes();
                    while (attributes.hasNext()) {
                        ConfigAttribute attr = (ConfigAttribute)attributes.next();
                        if (this.runAsManager.supports(attr) || this.accessDecisionManager.supports(attr) || this.afterInvocationManager != null && this.afterInvocationManager.supports(attr)) continue;
                        set.add(attr);
                    }
                }
                if (set.size() == 0) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"Validated configuration attributes");
                    }
                } else {
                    throw new IllegalArgumentException("Unsupported configuration attributes: " + ((Object)set).toString());
                }
            }
        }
    }

    protected Object afterInvocation(InterceptorStatusToken token, Object returnedObject) {
        if (token == null) {
            return returnedObject;
        }
        if (token.isContextHolderRefreshRequired()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Reverting to original Authentication: " + token.getAuthentication().toString()));
            }
            SecurityContextHolder.getContext().setAuthentication(token.getAuthentication());
        }
        if (this.afterInvocationManager != null) {
            returnedObject = this.afterInvocationManager.decide(token.getAuthentication(), token.getSecureObject(), token.getAttr(), returnedObject);
        }
        return returnedObject;
    }

    protected InterceptorStatusToken beforeInvocation(Object object) {
        Assert.notNull((Object)object, (String)"Object was null");
        Assert.isTrue((boolean)this.getSecureObjectClass().isAssignableFrom(object.getClass()), (String)("Security invocation attempted for object " + object.getClass().getName() + " but AbstractSecurityInterceptor only configured to support secure objects of type: " + this.getSecureObjectClass()));
        ConfigAttributeDefinition attr = this.obtainObjectDefinitionSource().getAttributes(object);
        if (attr != null) {
            Authentication authenticated;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Secure object: " + object.toString() + "; ConfigAttributes: " + attr.toString()));
            }
            if (SecurityContextHolder.getContext().getAuthentication() == null) {
                this.credentialsNotFound("Authentication credentials were not found in the SecurityContext", object, attr);
            }
            if (!SecurityContextHolder.getContext().getAuthentication().isAuthenticated() || this.alwaysReauthenticate) {
                authenticated = this.authenticationManager.authenticate(SecurityContextHolder.getContext().getAuthentication());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Successfully Authenticated: " + authenticated.toString()));
                }
                SecurityContextHolder.getContext().setAuthentication(authenticated);
            } else {
                authenticated = SecurityContextHolder.getContext().getAuthentication();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Previously Authenticated: " + authenticated.toString()));
                }
            }
            try {
                this.accessDecisionManager.decide(authenticated, object, attr);
            }
            catch (AccessDeniedException accessDeniedException) {
                AuthorizationFailureEvent event = new AuthorizationFailureEvent(object, attr, authenticated, accessDeniedException);
                this.eventPublisher.publishEvent((ApplicationEvent)event);
                throw accessDeniedException;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Authorization successful");
            }
            AuthorizedEvent event = new AuthorizedEvent(object, attr, authenticated);
            this.eventPublisher.publishEvent((ApplicationEvent)event);
            Authentication runAs = this.runAsManager.buildRunAs(authenticated, object, attr);
            if (runAs == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"RunAsManager did not change Authentication object");
                }
                return new InterceptorStatusToken(authenticated, false, attr, object);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Switching to RunAs Authentication: " + runAs.toString()));
            }
            SecurityContextHolder.getContext().setAuthentication(runAs);
            return new InterceptorStatusToken(authenticated, true, attr, object);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Public object - authentication not attempted");
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new PublicInvocationEvent(object));
        return null;
    }

    private void credentialsNotFound(String reason, Object secureObject, ConfigAttributeDefinition configAttribs) {
        AuthenticationCredentialsNotFoundException exception = new AuthenticationCredentialsNotFoundException(reason);
        AuthenticationCredentialsNotFoundEvent event = new AuthenticationCredentialsNotFoundEvent(secureObject, configAttribs, exception);
        this.eventPublisher.publishEvent((ApplicationEvent)event);
        throw exception;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

