/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.providers;

import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.UserDetails;

public abstract class AbstractAuthenticationToken
implements Authentication {
    public Object getDetails() {
        return null;
    }

    public String getName() {
        if (this.getPrincipal() instanceof UserDetails) {
            return ((UserDetails)this.getPrincipal()).getUsername();
        }
        return this.getPrincipal().toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractAuthenticationToken) {
            AbstractAuthenticationToken test = (AbstractAuthenticationToken)obj;
            if (this.getAuthorities() != null || test.getAuthorities() != null) {
                if (this.getAuthorities() == null || test.getAuthorities() == null) {
                    return false;
                }
                if (this.getAuthorities().length != test.getAuthorities().length) {
                    return false;
                }
                for (int i = 0; i < this.getAuthorities().length; ++i) {
                    if (this.getAuthorities()[i].equals(test.getAuthorities()[i])) continue;
                    return false;
                }
            }
            return this.getPrincipal().equals(test.getPrincipal()) && this.getCredentials().equals(test.getCredentials()) && this.isAuthenticated() == test.isAuthenticated();
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString()).append(": ");
        sb.append("Username: ").append(this.getPrincipal()).append("; ");
        sb.append("Password: [PROTECTED]; ");
        sb.append("Authenticated: ").append(this.isAuthenticated()).append("; ");
        sb.append("Details: ").append(this.getDetails()).append("; ");
        if (this.getAuthorities() != null) {
            sb.append("Granted Authorities: ");
            for (int i = 0; i < this.getAuthorities().length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.getAuthorities()[i].toString());
            }
        } else {
            sb.append("Not granted any authorities");
        }
        return sb.toString();
    }
}

