/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.providers;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net.sf.acegisecurity.AbstractAuthenticationManager;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationException;
import net.sf.acegisecurity.concurrent.ConcurrentSessionController;
import net.sf.acegisecurity.concurrent.NullConcurrentSessionController;
import net.sf.acegisecurity.event.authentication.AbstractAuthenticationEvent;
import net.sf.acegisecurity.event.authentication.AuthenticationSuccessEvent;
import net.sf.acegisecurity.providers.AuthenticationProvider;
import net.sf.acegisecurity.providers.ProviderNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.util.Assert;

public class ProviderManager
extends AbstractAuthenticationManager
implements InitializingBean,
ApplicationEventPublisherAware {
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$providers$ProviderManager == null ? (class$net$sf$acegisecurity$providers$ProviderManager = ProviderManager.class$("net.sf.acegisecurity.providers.ProviderManager")) : class$net$sf$acegisecurity$providers$ProviderManager));
    private ApplicationEventPublisher applicationEventPublisher;
    private ConcurrentSessionController sessionController = new NullConcurrentSessionController();
    private List providers;
    private Properties exceptionMappings;
    static /* synthetic */ Class class$net$sf$acegisecurity$providers$ProviderManager;
    static /* synthetic */ Class class$net$sf$acegisecurity$AccountExpiredException;
    static /* synthetic */ Class class$net$sf$acegisecurity$event$authentication$AuthenticationFailureExpiredEvent;
    static /* synthetic */ Class class$net$sf$acegisecurity$AuthenticationServiceException;
    static /* synthetic */ Class class$net$sf$acegisecurity$event$authentication$AuthenticationFailureServiceExceptionEvent;
    static /* synthetic */ Class class$net$sf$acegisecurity$LockedException;
    static /* synthetic */ Class class$net$sf$acegisecurity$event$authentication$AuthenticationFailureLockedEvent;
    static /* synthetic */ Class class$net$sf$acegisecurity$CredentialsExpiredException;
    static /* synthetic */ Class class$net$sf$acegisecurity$event$authentication$AuthenticationFailureCredentialsExpiredEvent;
    static /* synthetic */ Class class$net$sf$acegisecurity$DisabledException;
    static /* synthetic */ Class class$net$sf$acegisecurity$event$authentication$AuthenticationFailureDisabledEvent;
    static /* synthetic */ Class class$net$sf$acegisecurity$BadCredentialsException;
    static /* synthetic */ Class class$net$sf$acegisecurity$event$authentication$AuthenticationFailureBadCredentialsEvent;
    static /* synthetic */ Class class$net$sf$acegisecurity$providers$dao$UsernameNotFoundException;
    static /* synthetic */ Class class$net$sf$acegisecurity$concurrent$ConcurrentLoginException;
    static /* synthetic */ Class class$net$sf$acegisecurity$event$authentication$AuthenticationFailureConcurrentLoginEvent;
    static /* synthetic */ Class class$net$sf$acegisecurity$providers$ProviderNotFoundException;
    static /* synthetic */ Class class$net$sf$acegisecurity$event$authentication$AuthenticationFailureProviderNotFoundEvent;
    static /* synthetic */ Class class$net$sf$acegisecurity$providers$cas$ProxyUntrustedException;
    static /* synthetic */ Class class$net$sf$acegisecurity$event$authentication$AuthenticationFailureProxyUntrustedEvent;
    static /* synthetic */ Class class$net$sf$acegisecurity$Authentication;
    static /* synthetic */ Class class$net$sf$acegisecurity$AuthenticationException;
    static /* synthetic */ Class class$net$sf$acegisecurity$event$authentication$AbstractAuthenticationEvent;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setProviders(List newList) {
        this.checkIfValidList(newList);
        Iterator iter = newList.iterator();
        while (iter.hasNext()) {
            Object currentObject = null;
            try {
                currentObject = iter.next();
                AuthenticationProvider attemptToCast = (AuthenticationProvider)currentObject;
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException("AuthenticationProvider " + currentObject.getClass().getName() + " must implement AuthenticationProvider");
            }
        }
        this.providers = newList;
    }

    public List getProviders() {
        return this.providers;
    }

    public void setSessionController(ConcurrentSessionController sessionController) {
        this.sessionController = sessionController;
    }

    public ConcurrentSessionController getSessionController() {
        return this.sessionController;
    }

    public void afterPropertiesSet() throws Exception {
        this.checkIfValidList(this.providers);
        if (this.exceptionMappings == null) {
            this.exceptionMappings = new Properties();
            this.exceptionMappings.put((class$net$sf$acegisecurity$AccountExpiredException == null ? (class$net$sf$acegisecurity$AccountExpiredException = ProviderManager.class$("net.sf.acegisecurity.AccountExpiredException")) : class$net$sf$acegisecurity$AccountExpiredException).getName(), (class$net$sf$acegisecurity$event$authentication$AuthenticationFailureExpiredEvent == null ? (class$net$sf$acegisecurity$event$authentication$AuthenticationFailureExpiredEvent = ProviderManager.class$("net.sf.acegisecurity.event.authentication.AuthenticationFailureExpiredEvent")) : class$net$sf$acegisecurity$event$authentication$AuthenticationFailureExpiredEvent).getName());
            this.exceptionMappings.put((class$net$sf$acegisecurity$AuthenticationServiceException == null ? (class$net$sf$acegisecurity$AuthenticationServiceException = ProviderManager.class$("net.sf.acegisecurity.AuthenticationServiceException")) : class$net$sf$acegisecurity$AuthenticationServiceException).getName(), (class$net$sf$acegisecurity$event$authentication$AuthenticationFailureServiceExceptionEvent == null ? (class$net$sf$acegisecurity$event$authentication$AuthenticationFailureServiceExceptionEvent = ProviderManager.class$("net.sf.acegisecurity.event.authentication.AuthenticationFailureServiceExceptionEvent")) : class$net$sf$acegisecurity$event$authentication$AuthenticationFailureServiceExceptionEvent).getName());
            this.exceptionMappings.put((class$net$sf$acegisecurity$LockedException == null ? (class$net$sf$acegisecurity$LockedException = ProviderManager.class$("net.sf.acegisecurity.LockedException")) : class$net$sf$acegisecurity$LockedException).getName(), (class$net$sf$acegisecurity$event$authentication$AuthenticationFailureLockedEvent == null ? (class$net$sf$acegisecurity$event$authentication$AuthenticationFailureLockedEvent = ProviderManager.class$("net.sf.acegisecurity.event.authentication.AuthenticationFailureLockedEvent")) : class$net$sf$acegisecurity$event$authentication$AuthenticationFailureLockedEvent).getName());
            this.exceptionMappings.put((class$net$sf$acegisecurity$CredentialsExpiredException == null ? (class$net$sf$acegisecurity$CredentialsExpiredException = ProviderManager.class$("net.sf.acegisecurity.CredentialsExpiredException")) : class$net$sf$acegisecurity$CredentialsExpiredException).getName(), (class$net$sf$acegisecurity$event$authentication$AuthenticationFailureCredentialsExpiredEvent == null ? (class$net$sf$acegisecurity$event$authentication$AuthenticationFailureCredentialsExpiredEvent = ProviderManager.class$("net.sf.acegisecurity.event.authentication.AuthenticationFailureCredentialsExpiredEvent")) : class$net$sf$acegisecurity$event$authentication$AuthenticationFailureCredentialsExpiredEvent).getName());
            this.exceptionMappings.put((class$net$sf$acegisecurity$DisabledException == null ? (class$net$sf$acegisecurity$DisabledException = ProviderManager.class$("net.sf.acegisecurity.DisabledException")) : class$net$sf$acegisecurity$DisabledException).getName(), (class$net$sf$acegisecurity$event$authentication$AuthenticationFailureDisabledEvent == null ? (class$net$sf$acegisecurity$event$authentication$AuthenticationFailureDisabledEvent = ProviderManager.class$("net.sf.acegisecurity.event.authentication.AuthenticationFailureDisabledEvent")) : class$net$sf$acegisecurity$event$authentication$AuthenticationFailureDisabledEvent).getName());
            this.exceptionMappings.put((class$net$sf$acegisecurity$BadCredentialsException == null ? (class$net$sf$acegisecurity$BadCredentialsException = ProviderManager.class$("net.sf.acegisecurity.BadCredentialsException")) : class$net$sf$acegisecurity$BadCredentialsException).getName(), (class$net$sf$acegisecurity$event$authentication$AuthenticationFailureBadCredentialsEvent == null ? (class$net$sf$acegisecurity$event$authentication$AuthenticationFailureBadCredentialsEvent = ProviderManager.class$("net.sf.acegisecurity.event.authentication.AuthenticationFailureBadCredentialsEvent")) : class$net$sf$acegisecurity$event$authentication$AuthenticationFailureBadCredentialsEvent).getName());
            this.exceptionMappings.put((class$net$sf$acegisecurity$providers$dao$UsernameNotFoundException == null ? (class$net$sf$acegisecurity$providers$dao$UsernameNotFoundException = ProviderManager.class$("net.sf.acegisecurity.providers.dao.UsernameNotFoundException")) : class$net$sf$acegisecurity$providers$dao$UsernameNotFoundException).getName(), (class$net$sf$acegisecurity$event$authentication$AuthenticationFailureBadCredentialsEvent == null ? (class$net$sf$acegisecurity$event$authentication$AuthenticationFailureBadCredentialsEvent = ProviderManager.class$("net.sf.acegisecurity.event.authentication.AuthenticationFailureBadCredentialsEvent")) : class$net$sf$acegisecurity$event$authentication$AuthenticationFailureBadCredentialsEvent).getName());
            this.exceptionMappings.put((class$net$sf$acegisecurity$concurrent$ConcurrentLoginException == null ? (class$net$sf$acegisecurity$concurrent$ConcurrentLoginException = ProviderManager.class$("net.sf.acegisecurity.concurrent.ConcurrentLoginException")) : class$net$sf$acegisecurity$concurrent$ConcurrentLoginException).getName(), (class$net$sf$acegisecurity$event$authentication$AuthenticationFailureConcurrentLoginEvent == null ? (class$net$sf$acegisecurity$event$authentication$AuthenticationFailureConcurrentLoginEvent = ProviderManager.class$("net.sf.acegisecurity.event.authentication.AuthenticationFailureConcurrentLoginEvent")) : class$net$sf$acegisecurity$event$authentication$AuthenticationFailureConcurrentLoginEvent).getName());
            this.exceptionMappings.put((class$net$sf$acegisecurity$providers$ProviderNotFoundException == null ? (class$net$sf$acegisecurity$providers$ProviderNotFoundException = ProviderManager.class$("net.sf.acegisecurity.providers.ProviderNotFoundException")) : class$net$sf$acegisecurity$providers$ProviderNotFoundException).getName(), (class$net$sf$acegisecurity$event$authentication$AuthenticationFailureProviderNotFoundEvent == null ? (class$net$sf$acegisecurity$event$authentication$AuthenticationFailureProviderNotFoundEvent = ProviderManager.class$("net.sf.acegisecurity.event.authentication.AuthenticationFailureProviderNotFoundEvent")) : class$net$sf$acegisecurity$event$authentication$AuthenticationFailureProviderNotFoundEvent).getName());
            this.exceptionMappings.put((class$net$sf$acegisecurity$providers$cas$ProxyUntrustedException == null ? (class$net$sf$acegisecurity$providers$cas$ProxyUntrustedException = ProviderManager.class$("net.sf.acegisecurity.providers.cas.ProxyUntrustedException")) : class$net$sf$acegisecurity$providers$cas$ProxyUntrustedException).getName(), (class$net$sf$acegisecurity$event$authentication$AuthenticationFailureProxyUntrustedEvent == null ? (class$net$sf$acegisecurity$event$authentication$AuthenticationFailureProxyUntrustedEvent = ProviderManager.class$("net.sf.acegisecurity.event.authentication.AuthenticationFailureProxyUntrustedEvent")) : class$net$sf$acegisecurity$event$authentication$AuthenticationFailureProxyUntrustedEvent).getName());
            this.doAddExtraDefaultExceptionMappings(this.exceptionMappings);
        }
    }

    public Authentication doAuthentication(Authentication authentication) throws AuthenticationException {
        Iterator iter = this.providers.iterator();
        Class<?> toTest = authentication.getClass();
        Object lastException = null;
        while (iter.hasNext()) {
            AuthenticationProvider provider = (AuthenticationProvider)iter.next();
            if (!provider.supports(toTest)) continue;
            logger.debug((Object)("Authentication attempt using " + provider.getClass().getName()));
            Authentication result = null;
            try {
                result = provider.authenticate(authentication);
                this.sessionController.checkAuthenticationAllowed(result);
            }
            catch (AuthenticationException ae) {
                lastException = ae;
            }
            if (result == null) continue;
            this.sessionController.registerSuccessfulAuthentication(result);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new AuthenticationSuccessEvent(result));
            return result;
        }
        if (lastException == null) {
            lastException = new ProviderNotFoundException("No authentication provider for " + toTest.getName());
        }
        String className = this.exceptionMappings.getProperty(lastException.getClass().getName());
        AbstractAuthenticationEvent event = null;
        if (className != null) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(className);
                Constructor<?> constructor = clazz.getConstructor(class$net$sf$acegisecurity$Authentication == null ? (class$net$sf$acegisecurity$Authentication = ProviderManager.class$("net.sf.acegisecurity.Authentication")) : class$net$sf$acegisecurity$Authentication, class$net$sf$acegisecurity$AuthenticationException == null ? (class$net$sf$acegisecurity$AuthenticationException = ProviderManager.class$("net.sf.acegisecurity.AuthenticationException")) : class$net$sf$acegisecurity$AuthenticationException);
                Object obj = constructor.newInstance(authentication, lastException);
                Assert.isInstanceOf((Class)(class$net$sf$acegisecurity$event$authentication$AbstractAuthenticationEvent == null ? (class$net$sf$acegisecurity$event$authentication$AbstractAuthenticationEvent = ProviderManager.class$("net.sf.acegisecurity.event.authentication.AbstractAuthenticationEvent")) : class$net$sf$acegisecurity$event$authentication$AbstractAuthenticationEvent), obj, (String)"Must be an AbstractAuthenticationEvent");
                event = (AbstractAuthenticationEvent)((Object)obj);
            }
            catch (ClassNotFoundException ignored) {
            }
            catch (NoSuchMethodException ignored) {
            }
            catch (IllegalAccessException ignored) {
            }
            catch (InstantiationException ignored) {
            }
            catch (InvocationTargetException ignored) {
                // empty catch block
            }
        }
        if (event != null) {
            this.applicationEventPublisher.publishEvent(event);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("No event was found for the exception " + lastException.getClass().getName()));
        }
        throw lastException;
    }

    protected void doAddExtraDefaultExceptionMappings(Properties exceptionMappings) {
    }

    private void checkIfValidList(List listToCheck) {
        if (listToCheck == null || listToCheck.size() == 0) {
            throw new IllegalArgumentException("A list of AuthenticationManagers is required");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

