/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.providers.dao;

import net.sf.acegisecurity.AccountExpiredException;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationException;
import net.sf.acegisecurity.CredentialsExpiredException;
import net.sf.acegisecurity.DisabledException;
import net.sf.acegisecurity.LockedException;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.providers.AuthenticationProvider;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import net.sf.acegisecurity.providers.dao.UserCache;
import net.sf.acegisecurity.providers.dao.cache.NullUserCache;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public abstract class AbstractUserDetailsAuthenticationProvider
implements AuthenticationProvider,
InitializingBean {
    private UserCache userCache = new NullUserCache();
    private boolean forcePrincipalAsString = false;
    static /* synthetic */ Class class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken;

    public void setForcePrincipalAsString(boolean forcePrincipalAsString) {
        this.forcePrincipalAsString = forcePrincipalAsString;
    }

    public boolean isForcePrincipalAsString() {
        return this.forcePrincipalAsString;
    }

    public void setUserCache(UserCache userCache) {
        this.userCache = userCache;
    }

    public UserCache getUserCache() {
        return this.userCache;
    }

    public final void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.userCache, (String)"A user cache must be set");
        this.doAfterPropertiesSet();
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Assert.isInstanceOf((Class)(class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken == null ? (class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken = AbstractUserDetailsAuthenticationProvider.class$("net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken")) : class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken), (Object)authentication, (String)"Only UsernamePasswordAuthenticationToken is supported");
        String username = authentication.getPrincipal() == null ? "NONE_PROVIDED" : authentication.getName();
        boolean cacheWasUsed = true;
        UserDetails user = this.userCache.getUserFromCache(username);
        if (user == null) {
            cacheWasUsed = false;
            user = this.retrieveUser(username, (UsernamePasswordAuthenticationToken)authentication);
            Assert.notNull((Object)user, (String)"retrieveUser returned null - a violation of the interface contract");
        }
        if (!user.isAccountNonLocked()) {
            throw new LockedException("User account is locked");
        }
        if (!user.isEnabled()) {
            throw new DisabledException("User is disabled");
        }
        if (!user.isAccountNonExpired()) {
            throw new AccountExpiredException("User account has expired");
        }
        try {
            this.additionalAuthenticationChecks(user, (UsernamePasswordAuthenticationToken)authentication);
        }
        catch (AuthenticationException exception) {
            cacheWasUsed = false;
            user = this.retrieveUser(username, (UsernamePasswordAuthenticationToken)authentication);
            this.additionalAuthenticationChecks(user, (UsernamePasswordAuthenticationToken)authentication);
        }
        if (!user.isCredentialsNonExpired()) {
            throw new CredentialsExpiredException("User credentials have expired");
        }
        if (!cacheWasUsed) {
            this.userCache.putUserInCache(user);
        }
        Object principalToReturn = user;
        if (this.forcePrincipalAsString) {
            principalToReturn = user.getUsername();
        }
        return this.createSuccessAuthentication(principalToReturn, authentication, user);
    }

    public boolean supports(Class authentication) {
        return (class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken == null ? (class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken = AbstractUserDetailsAuthenticationProvider.class$("net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken")) : class$net$sf$acegisecurity$providers$UsernamePasswordAuthenticationToken).isAssignableFrom(authentication);
    }

    protected abstract void additionalAuthenticationChecks(UserDetails var1, UsernamePasswordAuthenticationToken var2) throws AuthenticationException;

    protected void doAfterPropertiesSet() throws Exception {
    }

    protected abstract UserDetails retrieveUser(String var1, UsernamePasswordAuthenticationToken var2) throws AuthenticationException;

    protected Authentication createSuccessAuthentication(Object principal, Authentication authentication, UserDetails user) {
        UsernamePasswordAuthenticationToken result = new UsernamePasswordAuthenticationToken(principal, authentication.getCredentials(), user.getAuthorities());
        result.setDetails(authentication.getDetails() != null ? authentication.getDetails() : null);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

