/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.providers.dao.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.GrantedAuthorityImpl;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.providers.dao.AuthenticationDao;
import net.sf.acegisecurity.providers.dao.User;
import net.sf.acegisecurity.providers.dao.UsernameNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.jdbc.object.MappingSqlQuery;

public class JdbcDaoImpl
extends JdbcDaoSupport
implements AuthenticationDao {
    public static final String DEF_USERS_BY_USERNAME_QUERY = "SELECT username,password,enabled FROM users WHERE username = ?";
    public static final String DEF_AUTHORITIES_BY_USERNAME_QUERY = "SELECT username,authority FROM authorities WHERE username = ?";
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$jdbc$core$support$JdbcDaoSupport == null ? (class$org$springframework$jdbc$core$support$JdbcDaoSupport = JdbcDaoImpl.class$("org.springframework.jdbc.core.support.JdbcDaoSupport")) : class$org$springframework$jdbc$core$support$JdbcDaoSupport));
    private MappingSqlQuery authoritiesByUsernameMapping;
    private MappingSqlQuery usersByUsernameMapping;
    private String authoritiesByUsernameQuery = "SELECT username,authority FROM authorities WHERE username = ?";
    private String rolePrefix = "";
    private String usersByUsernameQuery = "SELECT username,password,enabled FROM users WHERE username = ?";
    private boolean usernameBasedPrimaryKey = true;
    static /* synthetic */ Class class$org$springframework$jdbc$core$support$JdbcDaoSupport;

    public void setAuthoritiesByUsernameQuery(String queryString) {
        this.authoritiesByUsernameQuery = queryString;
    }

    public String getAuthoritiesByUsernameQuery() {
        return this.authoritiesByUsernameQuery;
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }

    public String getRolePrefix() {
        return this.rolePrefix;
    }

    public void setUsernameBasedPrimaryKey(boolean usernameBasedPrimaryKey) {
        this.usernameBasedPrimaryKey = usernameBasedPrimaryKey;
    }

    public boolean isUsernameBasedPrimaryKey() {
        return this.usernameBasedPrimaryKey;
    }

    public void setUsersByUsernameQuery(String usersByUsernameQueryString) {
        this.usersByUsernameQuery = usersByUsernameQueryString;
    }

    public String getUsersByUsernameQuery() {
        return this.usersByUsernameQuery;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        List users = this.usersByUsernameMapping.execute(username);
        if (users.size() == 0) {
            throw new UsernameNotFoundException("User not found");
        }
        UserDetails user = (UserDetails)users.get(0);
        List dbAuths = this.authoritiesByUsernameMapping.execute(user.getUsername());
        if (dbAuths.size() == 0) {
            throw new UsernameNotFoundException("User has no GrantedAuthority");
        }
        GrantedAuthority[] arrayAuths = new GrantedAuthority[]{};
        this.addCustomAuthorities(user.getUsername(), dbAuths);
        arrayAuths = dbAuths.toArray(arrayAuths);
        String returnUsername = user.getUsername();
        if (!this.usernameBasedPrimaryKey) {
            returnUsername = username;
        }
        return new User(returnUsername, user.getPassword(), user.isEnabled(), true, true, true, arrayAuths);
    }

    protected void addCustomAuthorities(String username, List authorities) {
    }

    protected void initDao() throws ApplicationContextException {
        this.initMappingSqlQueries();
    }

    protected void initMappingSqlQueries() {
        this.usersByUsernameMapping = new UsersByUsernameMapping(this.getDataSource());
        this.authoritiesByUsernameMapping = new AuthoritiesByUsernameMapping(this.getDataSource());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class UsersByUsernameMapping
    extends MappingSqlQuery {
        protected UsersByUsernameMapping(DataSource ds) {
            super(ds, JdbcDaoImpl.this.usersByUsernameQuery);
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }

        protected Object mapRow(ResultSet rs, int rownum) throws SQLException {
            String username = rs.getString(1);
            String password = rs.getString(2);
            boolean enabled = rs.getBoolean(3);
            User user = new User(username, password, enabled, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("HOLDER")});
            return user;
        }
    }

    protected class AuthoritiesByUsernameMapping
    extends MappingSqlQuery {
        protected AuthoritiesByUsernameMapping(DataSource ds) {
            super(ds, JdbcDaoImpl.this.authoritiesByUsernameQuery);
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }

        protected Object mapRow(ResultSet rs, int rownum) throws SQLException {
            String roleName = JdbcDaoImpl.this.rolePrefix + rs.getString(2);
            GrantedAuthorityImpl authority = new GrantedAuthorityImpl(roleName);
            return authority;
        }
    }
}

