/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.providers.dao.salt;

import java.lang.reflect.Method;
import net.sf.acegisecurity.AuthenticationServiceException;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.providers.dao.SaltSource;
import org.springframework.beans.factory.InitializingBean;

public class ReflectionSaltSource
implements SaltSource,
InitializingBean {
    private String userPropertyToUse;

    public Object getSalt(UserDetails user) {
        try {
            Method reflectionMethod = user.getClass().getMethod(this.userPropertyToUse, new Class[0]);
            return reflectionMethod.invoke((Object)user, new Object[0]);
        }
        catch (Exception exception) {
            throw new AuthenticationServiceException(exception.getMessage());
        }
    }

    public void setUserPropertyToUse(String userPropertyToUse) {
        this.userPropertyToUse = userPropertyToUse;
    }

    public String getUserPropertyToUse() {
        return this.userPropertyToUse;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getUserPropertyToUse() == null || "".equals(this.getUserPropertyToUse())) {
            throw new IllegalArgumentException("A userPropertyToUse must be set");
        }
    }
}

